# Complete Optimization Problem and Solution: activity_1

## 1. Problem Context and Goals

### Context  
The university is focused on optimizing the allocation of faculty members to various activities to enhance the overall participation scores. The decision-making process involves determining whether a faculty member, identified by their unique ID, should be assigned to a specific activity. This decision is represented by binary variables, where each variable indicates if a faculty member is assigned to an activity. The primary objective is to maximize the total participation score, which is calculated by summing the product of participation scores for each faculty-activity pair and the corresponding binary decision variable.

Operational parameters are crucial in this context. Each faculty member has a maximum number of activities they can participate in, ensuring they are not overburdened. Additionally, each activity requires a minimum number of faculty members to ensure it is adequately staffed. These parameters are derived from the business configuration, which includes the maximum number of activities a faculty member can participate in and the minimum number of faculty members required for an activity. The problem is structured to ensure that these constraints are respected, leading to a linear optimization formulation.

### Goals  
The primary goal of this optimization problem is to maximize the total participation score. This involves assigning faculty members to activities in a way that the sum of the participation scores for all faculty-activity assignments is maximized. The success of this optimization is measured by the total participation score achieved, which directly correlates with the participation scores assigned to each faculty-activity pair. The goal is articulated in natural language to emphasize the linear nature of the optimization objective.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the feasibility and practicality of the solution:

- Each faculty member can participate in a limited number of activities, as defined by their availability. This constraint ensures that the sum of the binary decision variables for each faculty member does not exceed their maximum availability.
- Each activity must have a minimum number of faculty members assigned to it. This constraint ensures that the sum of the binary decision variables for each activity meets or exceeds the required staffing level.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring that the problem remains within the realm of linear optimization.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data and updating existing tables to fill mapping gaps. Configuration logic updated for scalar parameters and formulas.

CREATE TABLE Participation_Score (
  FacID INTEGER,
  actid INTEGER,
  participation_score FLOAT
);

CREATE TABLE Faculty_Participates_in (
  FacID INTEGER,
  actid INTEGER,
  participation_score FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Participation_Score Table**: This table stores the participation scores for each faculty-activity pair. The participation score represents the benefit of assigning a specific faculty member to an activity. The table includes:
  - **FacID**: Represents the unique identifier for each faculty member.
  - **actid**: Represents the unique identifier for each activity.
  - **participation_score**: Represents the score associated with assigning a faculty member to an activity, serving as a coefficient in the objective function.

- **Faculty_Participates_in Table**: This table tracks the participation of faculty members in activities. It includes:
  - **FacID**: Represents the unique identifier for each faculty member.
  - **actid**: Represents the unique identifier for each activity.
  - **participation_score**: Although included, this column is primarily used for tracking purposes and aligns with the participation scores in the Participation_Score table.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical faculty workloads and activity requirements in a university setting, ensuring a balance between faculty availability and activity needs.

-- Realistic data for Participation_Score
INSERT INTO Participation_Score (FacID, actid, participation_score) VALUES (1, 101, 12.0);
INSERT INTO Participation_Score (FacID, actid, participation_score) VALUES (2, 102, 18.5);
INSERT INTO Participation_Score (FacID, actid, participation_score) VALUES (3, 103, 14.0);

-- Realistic data for Faculty_Participates_in
INSERT INTO Faculty_Participates_in (FacID, actid, participation_score) VALUES (1, 101, 12.0);
INSERT INTO Faculty_Participates_in (FacID, actid, participation_score) VALUES (2, 102, 18.5);
INSERT INTO Faculty_Participates_in (FacID, actid, participation_score) VALUES (3, 103, 14.0);
INSERT INTO Faculty_Participates_in (FacID, actid, participation_score) VALUES (1, 102, 10.0);
INSERT INTO Faculty_Participates_in (FacID, actid, participation_score) VALUES (2, 103, 16.0);
```