# Complete Optimization Problem and Solution: aircraft

## 1. Problem Context and Goals

### Context  
The objective is to optimize the allocation of aircraft to various airports to maximize the total number of passengers transported. This involves making decisions about the number of aircraft assigned to each airport, which is represented by the decision variable 'number_of_aircraft[i]'. Each aircraft has a specific passenger capacity, and the goal is to maximize the total passengers transported, calculated as the sum of the product of each aircraft's capacity and the number of aircraft assigned to each airport.

Operational parameters include the maximum weight capacity of each aircraft, which serves as a constraint to ensure that the number of passengers transported by any aircraft does not exceed its capacity. Additionally, there is a constraint on the maximum number of aircraft movements allowed at each airport, ensuring that the total aircraft movements do not exceed this limit. These constraints are critical to maintaining operational feasibility and are derived from the business configuration parameters.

### Goals  
The primary goal of this optimization problem is to maximize the total number of passengers transported across all airports. This is achieved by optimizing the allocation of aircraft to airports, ensuring that the total passenger capacity is fully utilized. The success of this optimization is measured by the total number of passengers transported, which is directly linked to the aircraft capacities and the number of aircraft assigned to each airport. The optimization goal is clearly defined in linear terms, focusing on maximizing the sum of the passenger capacities of the assigned aircraft.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure operational feasibility:

- **Aircraft Capacity Constraint**: For each aircraft, the number of passengers transported cannot exceed its capacity. This constraint ensures that the allocation of aircraft respects the maximum weight capacity of each aircraft, as defined in the business configuration.

- **Airport Movement Constraint**: The total number of aircraft movements at each airport cannot exceed the specified limit. This constraint ensures that the operations at each airport remain within the allowable movement limits, maintaining efficient and feasible airport operations.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains within the realm of linear programming.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding tables for passenger capacity and aircraft assignments, modifying existing tables to include missing data, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE passenger_capacity (
  aircraft_id INTEGER,
  capacity INTEGER
);

CREATE TABLE aircraft_assignment (
  airport_id INTEGER,
  number_of_aircraft INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Passenger Capacity Table**: This table stores the passenger capacity for each aircraft. The 'aircraft_id' column uniquely identifies each aircraft, while the 'capacity' column represents the passenger capacity of the aircraft. This data is crucial for determining the coefficients in the optimization objective, linking each aircraft's capacity to its potential contribution to the total passengers transported.

- **Aircraft Assignment Table**: This table tracks the number of aircraft assigned to each airport. The 'airport_id' column uniquely identifies each airport, and the 'number_of_aircraft' column indicates the number of aircraft assigned to that airport. This data serves as the decision variable in the optimization model, directly influencing the allocation strategy to maximize passenger transport.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical aircraft capacities and airport movement limits, ensuring a balance between aircraft capabilities and airport constraints.

-- Realistic data for passenger_capacity
INSERT INTO passenger_capacity (aircraft_id, capacity) VALUES (1, 150);
INSERT INTO passenger_capacity (aircraft_id, capacity) VALUES (2, 180);
INSERT INTO passenger_capacity (aircraft_id, capacity) VALUES (3, 200);

-- Realistic data for aircraft_assignment
INSERT INTO aircraft_assignment (airport_id, number_of_aircraft) VALUES (1, 3);
INSERT INTO aircraft_assignment (airport_id, number_of_aircraft) VALUES (2, 5);
INSERT INTO aircraft_assignment (airport_id, number_of_aircraft) VALUES (3, 7);
```