# Complete Optimization Problem and Solution: allergy_1

## 1. Problem Context and Goals

### Context  
The university is focused on efficiently assigning students to dormitories while minimizing the discomfort of students with allergies. The primary decision involves determining whether a student is assigned to a specific dormitory, represented by binary variables. The objective is to minimize the total penalty incurred from assigning students with allergies to dormitories that are not allergy-friendly. This is achieved by considering the penalty values associated with such assignments. The operational parameters include the maximum number of students each dormitory can accommodate, which serves as a constraint in the optimization model. The business logic involves calculating penalties based on the assignment of students with allergies to non-allergy-friendly dormitories, ensuring that the optimization process focuses on minimizing these penalties. The data reflects current operational conditions, emphasizing linear relationships without involving complex mathematical operations like variable products or divisions. The business configuration includes both scalar parameters, such as dormitory capacity limits, and business logic formulas, ensuring a comprehensive approach to decision-making.

### Goals  
The primary goal of the optimization is to minimize the total penalty associated with assigning students with allergies to non-allergy-friendly dormitories. This involves reducing the sum of penalty values linked to such assignments. Success is measured by the extent to which the optimization reduces these penalties, aligning with the expected sources of coefficients. The objective is clearly defined in linear terms, focusing on minimizing the total penalty without involving complex mathematical expressions.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure feasible and effective student assignments:

- Each student must be assigned to exactly one dormitory. This ensures that every student has a designated living space.
- The number of students assigned to a dormitory cannot exceed its capacity. This constraint respects the physical limitations of each dormitory.
- Students with allergies cannot be assigned to dormitories that are not allergy-friendly. This constraint prevents assignments that would incur penalties, aligning with the objective of minimizing discomfort for students with allergies.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, avoiding any complex operations.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a table for decision variables and updating configuration logic for scalar parameters and formulas based on OR expert mapping analysis.

CREATE TABLE dormitory_capacity (
  dormitory_id INTEGER,
  capacity INTEGER
);

CREATE TABLE dormitory_allergy_friendly (
  dormitory_id INTEGER,
  is_allergy_friendly BOOLEAN
);

CREATE TABLE allergy_penalty (
  student_id INTEGER,
  dormitory_id INTEGER,
  penalty_value FLOAT
);

CREATE TABLE student_dormitory_assignment (
  student_id INTEGER,
  dormitory_id INTEGER,
  assignment BOOLEAN
);


```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns, highlighting their business purposes and roles in the optimization process:

- **Dormitory Capacity**: This table records the maximum number of students each dormitory can accommodate, serving as a constraint in the optimization model.
  - **dormitory_id**: Identifies each dormitory uniquely, linking capacity information to specific dormitories.
  - **capacity**: Represents the maximum student capacity for each dormitory, used as a constraint bound.

- **Dormitory Allergy-Friendly Status**: This table indicates whether each dormitory is suitable for students with allergies.
  - **dormitory_id**: Uniquely identifies each dormitory, linking allergy-friendliness information.
  - **is_allergy_friendly**: Shows whether a dormitory is allergy-friendly, influencing valid student assignments.

- **Allergy Penalty**: This table stores penalty values for assigning students with allergies to non-allergy-friendly dormitories.
  - **student_id**: Uniquely identifies each student, linking penalty information.
  - **dormitory_id**: Uniquely identifies each dormitory, linking penalty information.
  - **penalty_value**: Represents the penalty for assigning a student with allergies to a non-allergy-friendly dormitory, used in the objective function.

- **Student Dormitory Assignment**: This table records the assignment of students to dormitories as binary decision variables.
  - **student_id**: Uniquely identifies each student, linking assignment information.
  - **dormitory_id**: Uniquely identifies each dormitory, linking assignment information.
  - **assignment**: Indicates whether a student is assigned to a dormitory, used as a decision variable in the optimization.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical university dormitory capacities, common allergy considerations, and realistic penalty values to ensure a meaningful optimization problem.

-- Realistic data for dormitory_capacity
INSERT INTO dormitory_capacity (dormitory_id, capacity) VALUES (1, 50);
INSERT INTO dormitory_capacity (dormitory_id, capacity) VALUES (2, 100);
INSERT INTO dormitory_capacity (dormitory_id, capacity) VALUES (3, 150);

-- Realistic data for dormitory_allergy_friendly
INSERT INTO dormitory_allergy_friendly (dormitory_id, is_allergy_friendly) VALUES (1, True);
INSERT INTO dormitory_allergy_friendly (dormitory_id, is_allergy_friendly) VALUES (2, False);
INSERT INTO dormitory_allergy_friendly (dormitory_id, is_allergy_friendly) VALUES (3, True);

-- Realistic data for allergy_penalty
INSERT INTO allergy_penalty (student_id, dormitory_id, penalty_value) VALUES (101, 2, 20.0);
INSERT INTO allergy_penalty (student_id, dormitory_id, penalty_value) VALUES (102, 2, 25.0);
INSERT INTO allergy_penalty (student_id, dormitory_id, penalty_value) VALUES (103, 2, 15.0);

-- Realistic data for student_dormitory_assignment
INSERT INTO student_dormitory_assignment (student_id, dormitory_id, assignment) VALUES (101, 1, True);
INSERT INTO student_dormitory_assignment (student_id, dormitory_id, assignment) VALUES (102, 3, True);
INSERT INTO student_dormitory_assignment (student_id, dormitory_id, assignment) VALUES (103, 2, False);


```