# Complete Optimization Problem and Solution: body_builder

## 1. Problem Context and Goals

### Context  
The fitness organization is focused on enhancing the competitive performance of bodybuilders by optimizing their training regimen. The primary decision variables in this optimization are the weights lifted in the Snatch and Clean & Jerk events. These variables are continuous and directly mapped to the bodybuilder's performance in these lifts. The operational goal is to maximize the total weight lifted across these events, aligning with the linear objective of summing the weights lifted in Snatch and Clean & Jerk.

The business configuration includes several key parameters: the target total weight to be lifted by a bodybuilder, which serves as a constraint in the optimization model, and the impact coefficients for Snatch and Clean & Jerk training, which adjust the focus of training in the optimization model. These parameters are crucial for ensuring that the optimization aligns with realistic training impacts and performance targets.

The organization uses current operational data to inform decision-making, ensuring that the optimization problem remains grounded in practical, achievable goals. The constraints are designed to reflect resource limitations and performance targets, ensuring that the optimization remains linear and avoids nonlinear relationships such as variable products or divisions. The business configuration parameters are referenced throughout to maintain consistency and alignment with the optimization objectives.

### Goals  
The primary goal of the optimization is to maximize the total weight lifted by bodybuilders in competitions. This is achieved by focusing on the Snatch and Clean & Jerk lifts, with the objective being to maximize the sum of the weights lifted in these events. Success is measured by the alignment of the optimization with the expected impact coefficients for training, ensuring that the focus on Snatch and Clean & Jerk lifts leads to improved competitive performance. The optimization goal is clearly defined in natural language, emphasizing the linear nature of the objective without resorting to mathematical formulas or symbolic notation.

## 2. Constraints    

The optimization problem includes constraints that ensure the total weight lifted by each bodybuilder does not exceed specified limits. These constraints are directly mapped to the total weight lifted by the bodybuilder, ensuring that the optimization remains within realistic performance boundaries. Additionally, each bodybuilder has a performance target, which serves as a constraint in the optimization model. These constraints are described in business terms, naturally leading to linear mathematical forms without involving variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema adjustments and configuration logic updates were made to address missing performance targets and training impact coefficients, ensuring alignment with optimization requirements.

CREATE TABLE body_builder (
  Snatch FLOAT,
  Clean_Jerk FLOAT,
  Total FLOAT,
  Snatch_Impact FLOAT,
  Clean_Jerk_Impact FLOAT
);

CREATE TABLE bodybuilder_performance (
  Bodybuilder_ID INTEGER,
  Performance_Target FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles. The `body_builder` table stores individual lift data for bodybuilders, with columns representing the weight lifted in Snatch and Clean & Jerk, the total weight lifted, and the impact coefficients for training. These columns serve as decision variables and objective coefficients in the optimization model. The `bodybuilder_performance` table stores performance metrics and targets for each bodybuilder, linking performance data to individual bodybuilders and serving as a constraint in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical competitive weightlifting standards and the need to balance training impact coefficients with performance targets.

-- Realistic data for body_builder
INSERT INTO body_builder (Snatch, Clean_Jerk, Total, Snatch_Impact, Clean_Jerk_Impact) VALUES (85.0, 105.0, 190.0, 1.2, 1.5);
INSERT INTO body_builder (Snatch, Clean_Jerk, Total, Snatch_Impact, Clean_Jerk_Impact) VALUES (95.0, 115.0, 210.0, 1.3, 1.6);
INSERT INTO body_builder (Snatch, Clean_Jerk, Total, Snatch_Impact, Clean_Jerk_Impact) VALUES (100.0, 120.0, 220.0, 1.1, 1.4);

-- Realistic data for bodybuilder_performance
INSERT INTO bodybuilder_performance (Bodybuilder_ID, Performance_Target) VALUES (1, 300.0);
INSERT INTO bodybuilder_performance (Bodybuilder_ID, Performance_Target) VALUES (2, 320.0);
INSERT INTO bodybuilder_performance (Bodybuilder_ID, Performance_Target) VALUES (3, 340.0);
```