# Complete DOCPLEX implementation - Retry Attempt 1

from docplex.mp.model import Model

def club_optimization():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="club_optimization")
    
    # Data from the problem statement
    preference_scores = [
        (1, 101, 8),
        (1, 102, 3),
        (2, 101, 5),
        (2, 103, 7),
        (3, 102, 6),
        (3, 103, 4)
    ]
    
    club_capacities = {
        101: 60,
        102: 40,
        103: 50
    }
    
    # Extract unique students and clubs
    students = set(stu for stu, _, _ in preference_scores)
    clubs = set(club for _, club, _ in preference_scores)
    
    # Validate data consistency
    assert all(isinstance(score, int) for _, _, score in preference_scores), "Preference scores must be integers"
    assert all(isinstance(cap, int) for cap in club_capacities.values()), "Capacities must be integers"
    
    # 2. VARIABLES
    x = {(stu, club): mdl.binary_var(name=f"x_{stu}_{club}") for stu in students for club in clubs}
    
    # 3. OBJECTIVE FUNCTION
    objective = mdl.sum(preference_score * x[stu, club] for stu, club, preference_score in preference_scores)
    mdl.maximize(objective)
    
    # 4. CONSTRAINTS
    # Club capacity constraints
    for club in clubs:
        mdl.add_constraint(mdl.sum(x[stu, club] for stu in students) <= club_capacities[club], ctname=f"capacity_{club}")
    
    # 5. SOLVING & RESULTS
    solution = mdl.solve()
    
    if solution:
        print(f"Optimal value: {solution.objective_value}")
        for stu, club in x:
            if solution.get_value(x[stu, club]) > 0.5:  # Binary variable check
                print(f"Student {stu} assigned to Club {club}")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")

# Run the optimization
club_optimization()