# Complete Optimization Problem and Solution: club_1

## 1. Problem Context and Goals

### Context  
The university is focused on enhancing student engagement by optimally assigning students to various clubs. The decision-making process involves determining whether a student should be assigned to a specific club, represented by binary variables. The primary objective is to maximize the overall engagement score, which is calculated by summing the preference scores of students for the clubs they are assigned to. Each club has a maximum capacity, which serves as a constraint in the optimization model. The preference score of a student for a club acts as a coefficient in the objective function, guiding the assignment decisions. The business configuration includes parameters such as the maximum number of students that can be assigned to a club and the preference score, both of which are crucial for the optimization model. The problem is structured to ensure linear relationships, avoiding any nonlinear scenarios such as variable products or divisions. The operational parameters are clearly defined to align with the expected linear objective and constraints.

### Goals  
The primary goal of this optimization problem is to maximize the total engagement score by assigning students to clubs based on their preference scores. The metric to optimize is the sum of the preference scores for the student-club assignments. Success is measured by how well the assignments maximize this sum, adhering to the constraints of club capacities. The optimization goal is articulated in natural language, focusing on maximizing student engagement through strategic club assignments.

## 2. Constraints    

The constraints for this optimization problem are designed to ensure that the assignments adhere to the club capacities and the binary nature of the decision variables. Each club has a maximum number of students it can accommodate, and this serves as a constraint in the model. Specifically, the total number of students assigned to a club must not exceed its capacity. Additionally, the assignment of students to clubs is represented by binary variables, indicating whether a student is assigned to a particular club or not. These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring clarity and alignment with the optimization model.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a table for decision variables, updating configuration logic for scalar parameters and formulas, and ensuring all optimization requirements are mapped.

CREATE TABLE PreferenceScores (
  StuID INTEGER,
  ClubID INTEGER,
  preference_score INTEGER
);

CREATE TABLE ClubCapacities (
  ClubID INTEGER,
  capacity INTEGER
);

CREATE TABLE StudentClubAssignments (
  StuID INTEGER,
  ClubID INTEGER,
  assignment BOOLEAN
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **PreferenceScores Table**: This table stores the preference scores of students for each club. The preference score acts as a coefficient in the objective function, guiding the optimization process. Each entry includes a unique student identifier (StuID), a club identifier (ClubID), and the preference score.

- **ClubCapacities Table**: This table contains the maximum capacity for each club, which serves as a constraint bound in the optimization model. It includes a club identifier (ClubID) and the capacity, representing the maximum number of students that can be assigned to the club.

- **StudentClubAssignments Table**: This table records the binary decision variables indicating whether a student is assigned to a club. It includes a student identifier (StuID), a club identifier (ClubID), and the assignment status, which is a binary value.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical university club sizes and student preferences, ensuring a diverse range of preference scores and club capacities to create a meaningful optimization problem.

-- Realistic data for PreferenceScores
INSERT INTO PreferenceScores (StuID, ClubID, preference_score) VALUES (1, 101, 8);
INSERT INTO PreferenceScores (StuID, ClubID, preference_score) VALUES (1, 102, 3);
INSERT INTO PreferenceScores (StuID, ClubID, preference_score) VALUES (2, 101, 5);
INSERT INTO PreferenceScores (StuID, ClubID, preference_score) VALUES (2, 103, 7);
INSERT INTO PreferenceScores (StuID, ClubID, preference_score) VALUES (3, 102, 6);
INSERT INTO PreferenceScores (StuID, ClubID, preference_score) VALUES (3, 103, 4);

-- Realistic data for ClubCapacities
INSERT INTO ClubCapacities (ClubID, capacity) VALUES (101, 60);
INSERT INTO ClubCapacities (ClubID, capacity) VALUES (102, 40);
INSERT INTO ClubCapacities (ClubID, capacity) VALUES (103, 50);

-- Realistic data for StudentClubAssignments
INSERT INTO StudentClubAssignments (StuID, ClubID, assignment) VALUES (1, 101, True);
INSERT INTO StudentClubAssignments (StuID, ClubID, assignment) VALUES (2, 103, True);
INSERT INTO StudentClubAssignments (StuID, ClubID, assignment) VALUES (3, 102, True);
```