# Complete Optimization Problem and Solution: customers_card_transactions

## 1. Problem Context and Goals

### Context  
A financial institution is focused on optimizing the allocation of credit limits to customer accounts. The primary decision involves determining the appropriate credit limit for each account, which is treated as a continuous variable. The institution aims to maximize the total expected transaction volume, which is directly influenced by the credit limits assigned to each account. This objective aligns with the operational goal of maximizing the sum of expected transaction volumes across all accounts, where each account's expected volume acts as a coefficient in the optimization process.

The business configuration includes critical parameters such as the total credit available for allocation across all accounts, which serves as a constraint to ensure that the total assigned credit does not exceed this limit. Additionally, there is a minimum credit limit requirement for an account to be considered active, ensuring that accounts have sufficient credit to facilitate meaningful transactions. These parameters are essential for maintaining a balance between business growth and risk management.

The data used in this optimization process reflects current operational information, ensuring that decisions are based on realistic and up-to-date insights. The constraints are designed to be linear, avoiding any nonlinear relationships such as variable products or divisions, and are directly tied to the business configuration parameters.

### Goals  
The primary goal of this optimization problem is to maximize the total expected transaction volume across all customer accounts. This is achieved by strategically allocating credit limits to each account, with the objective of maximizing the sum of the products of expected transaction volumes and their respective credit limits. Success in this optimization is measured by the increase in total expected transaction volume, which is directly linked to the coefficients derived from the expected volumes of each account. The optimization goal is clearly defined in linear terms, ensuring a straightforward and efficient solution process.

## 2. Constraints    

The optimization problem is subject to several linear constraints that ensure the solution is both feasible and aligned with business objectives:

- The total credit allocated across all accounts must not exceed the total available credit. This constraint ensures that the institution operates within its financial capacity and manages risk effectively.
- Each account's credit limit must not exceed its maximum allowable credit limit. This constraint is crucial for maintaining individual account risk limits and preventing overexposure.
- For an account to be considered active, its credit limit must meet or exceed the minimum credit limit requirement. This ensures that active accounts have enough credit to support meaningful transactions and contribute to the overall transaction volume.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, facilitating a straightforward optimization process.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data, modifying existing tables to fill mapping gaps, and moving certain parameters to configuration logic for better management.

CREATE TABLE account_expected_transaction_volume (
  account_id INTEGER,
  expected_volume FLOAT
);

CREATE TABLE account_credit_limits (
  account_id INTEGER,
  credit_limit FLOAT,
  max_credit_limit FLOAT,
  is_active BOOLEAN
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **account_expected_transaction_volume**: This table stores the expected transaction volume for each account. The expected volume serves as a coefficient in the optimization objective, representing the potential transaction activity associated with each account.

  - **account_id**: A unique identifier for each account, used to index expected transaction volumes.
  - **expected_volume**: The anticipated transaction volume for the account, acting as a coefficient in the objective function.

- **account_credit_limits**: This table contains information about the credit limits and status of each account. It plays a crucial role in defining the constraints of the optimization problem.

  - **account_id**: A unique identifier for each account, used to index credit limits.
  - **credit_limit**: The credit limit allocated to the account, which is the decision variable in the optimization model.
  - **max_credit_limit**: The maximum allowable credit limit for the account, serving as a constraint bound.
  - **is_active**: A boolean indicator of whether the account is active, determining if the credit limit can be greater than zero.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical credit limits and transaction volumes observed in financial institutions, ensuring a balance between risk management and business growth objectives.

-- Realistic data for account_expected_transaction_volume
INSERT INTO account_expected_transaction_volume (account_id, expected_volume) VALUES (1, 1200.0);
INSERT INTO account_expected_transaction_volume (account_id, expected_volume) VALUES (2, 1800.0);
INSERT INTO account_expected_transaction_volume (account_id, expected_volume) VALUES (3, 2200.0);

-- Realistic data for account_credit_limits
INSERT INTO account_credit_limits (account_id, credit_limit, max_credit_limit, is_active) VALUES (1, 800.0, 2000.0, True);
INSERT INTO account_credit_limits (account_id, credit_limit, max_credit_limit, is_active) VALUES (2, 1500.0, 2500.0, True);
INSERT INTO account_credit_limits (account_id, credit_limit, max_credit_limit, is_active) VALUES (3, 1800.0, 3000.0, True);
```