# Complete DOCPLEX implementation - Retry Attempt 3

from docplex.mp.model import Model

def device_allocation_optimization():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="device_allocation")
    
    # Data from the problem statement
    shop_ids = [1, 2, 3]
    device_ids = [101, 102, 103]
    potential_sales = {
        (1, 101): 600.0,
        (2, 102): 850.0,
        (3, 103): 950.0
    }
    shop_capacity = {
        1: 120,
        2: 180,
        3: 220
    }
    
    # Validate data lengths
    assert len(potential_sales) == len(shop_ids) == len(device_ids), "Data length mismatch"
    
    # 2. VARIABLES
    x = {(i, j): mdl.integer_var(name=f"x_{i}_{j}", lb=0) for i in shop_ids for j in device_ids}
    
    # 3. OBJECTIVE FUNCTION
    objective = mdl.sum(potential_sales[i, j] * x[i, j] for i, j in potential_sales)
    mdl.maximize(objective)
    
    # 4. CONSTRAINTS
    # Shop capacity constraints
    for i in shop_ids:
        mdl.add_constraint(mdl.sum(x[i, j] for j in device_ids if (i, j) in potential_sales) <= shop_capacity[i], ctname=f"capacity_{i}")
    
    # 5. SOLVING & RESULTS
    solution = mdl.solve()
    
    if solution:
        print(f"Optimal value: {solution.objective_value}")
        for i, j in potential_sales:
            value = solution.get_value(x[i, j])
            if value > 1e-6:
                print(f"x[{i},{j}] = {value:.3f}")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")

# Execute the optimization
device_allocation_optimization()