# Complete Optimization Problem and Solution: dorm_1

## 1. Problem Context and Goals

### Context  
The primary objective is to allocate students to dormitories in a manner that maximizes the utilization of dorm capacity while ensuring that students are assigned to dorms that match their gender. Each student is uniquely identified and can be assigned to a specific dorm, represented by a binary decision variable indicating whether a student is assigned to a particular dorm. The operational goal is to maximize the sum of coefficients associated with each student-dorm assignment, reflecting the value or preference of such assignments.

The business configuration includes a maximum capacity for each dormitory, which serves as a constraint to ensure that no dorm exceeds its capacity. Additionally, a business logic formula ensures gender compatibility by verifying that students are only assigned to dorms that match their gender. This setup allows for precise operational decision-making that aligns with linear optimization formulations, avoiding any nonlinear relationships such as variable products or divisions.

### Goals  
The optimization goal is to maximize the overall effectiveness of student assignments to dorms. This is achieved by maximizing the sum of the coefficients associated with each student-dorm assignment. The success of this optimization is measured by how well the assignments align with the expected coefficients, ensuring that the most preferred or valuable assignments are prioritized. The goal is articulated in natural language to emphasize the linear nature of the optimization process.

## 2. Constraints    

The constraints for this optimization problem are designed to ensure that the solution adheres to the business requirements:

- Each dormitory has a maximum capacity, and the total number of students assigned to a dorm must not exceed this limit. This constraint ensures that the dorm capacity is respected and is expressed in terms of the sum of assignments for each dorm.
  
- Gender compatibility is maintained by ensuring that students are only assigned to dorms that match their gender. This constraint is implemented through a business logic formula that verifies gender matching for each student-dorm pair.

These constraints are articulated in business terms that naturally lead to linear mathematical forms, ensuring clarity and alignment with the optimization model.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and objective coefficients, modifying existing tables to fill mapping gaps, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE StudentDormAssignment (
  StuID INTEGER,
  DormID INTEGER,
  assignment BOOLEAN
);

CREATE TABLE ObjectiveCoefficients (
  StuID INTEGER,
  DormID INTEGER,
  coefficient FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **StudentDormAssignment Table**: This table tracks the assignment of students to dorms. It includes:
  - **StuID**: A unique identifier for each student, used to identify students in the assignment process.
  - **DormID**: A unique identifier for each dorm, used to identify dorms in the assignment process.
  - **Assignment**: A binary indicator showing whether a student is assigned to a dorm, serving as the decision variable in the optimization model.

- **ObjectiveCoefficients Table**: This table stores the coefficients used in the objective function. It includes:
  - **StuID**: A unique identifier for each student, part of the index for the coefficient.
  - **DormID**: A unique identifier for each dorm, part of the index for the coefficient.
  - **Coefficient**: The value of the coefficient for the objective function, representing the preference or value of a student-dorm assignment.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical dorm capacities and student distribution to ensure a balanced and realistic allocation scenario.

-- Realistic data for StudentDormAssignment
INSERT INTO StudentDormAssignment (StuID, DormID, assignment) VALUES (1, 101, True);
INSERT INTO StudentDormAssignment (StuID, DormID, assignment) VALUES (2, 102, True);
INSERT INTO StudentDormAssignment (StuID, DormID, assignment) VALUES (3, 103, False);

-- Realistic data for ObjectiveCoefficients
INSERT INTO ObjectiveCoefficients (StuID, DormID, coefficient) VALUES (1, 101, 1.0);
INSERT INTO ObjectiveCoefficients (StuID, DormID, coefficient) VALUES (2, 102, 1.0);
INSERT INTO ObjectiveCoefficients (StuID, DormID, coefficient) VALUES (3, 103, 0.5);
```