# Complete Optimization Problem and Solution: election

## 1. Problem Context and Goals

### Context  
In the context of an upcoming election, the political party aims to strategically allocate campaign resources across various counties to maximize the number of votes received. The decision-making process involves determining the amount of resources to allocate to each county, represented by the decision variable `resource_allocation[i]`, which is continuous for each county `i`. The objective is to maximize the expected votes, which is a linear function of the resources allocated, weighted by the expected votes gained per unit of resource for each county.

The operational parameters guiding this allocation include a total budget constraint, ensuring that the sum of resources allocated does not exceed the available budget. Additionally, there are minimum and maximum resource allocation constraints for each county to ensure a balanced and effective distribution of resources. The total budget available for resource allocation acts as an upper bound, while the minimum and maximum allocations per county serve as lower and upper bounds, respectively. These constraints are designed to maintain a strategic and feasible allocation of resources across all counties.

### Goals  
The primary goal of this optimization problem is to maximize the total expected votes for the political party. This is achieved by optimizing the allocation of resources across counties, where the metric to optimize is the sum of the product of the expected votes per resource unit and the resources allocated to each county. The success of this optimization is measured by the alignment of resource allocation with the expected vote coefficients, ensuring that resources are distributed in a manner that maximizes the overall vote count. The optimization goal is clearly defined in linear terms, focusing on maximizing the linear combination of resource allocations and vote coefficients.

## 2. Constraints    

The optimization problem is subject to several linear constraints that ensure the feasibility and strategic distribution of resources:

- The total resources allocated across all counties must not exceed the total budget available. This constraint ensures that the allocation remains within the financial limits set for the campaign.
- Each county must receive a minimum amount of resources, ensuring that every county has enough resources to make a meaningful impact on the election outcome.
- The resources allocated to each county must not exceed a specified maximum, preventing over-investment in any single county and promoting a balanced distribution of resources.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains linear and solvable using standard linear optimization techniques.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for objective coefficients, constraint bounds, and decision variables. Business configuration logic is updated to include scalar parameters and formulas for optimization constraints and objectives.

CREATE TABLE ObjectiveCoefficients (
  county_id INTEGER,
  votes_coefficient FLOAT
);

CREATE TABLE DecisionVariables (
  county_id INTEGER,
  resource_allocation FLOAT
);
```

### Data Dictionary  
The data used in this optimization problem is organized into tables that serve specific business purposes and optimization roles:

- **ObjectiveCoefficients Table**: This table stores the coefficients used in the objective function, representing the expected votes gained per unit of resource for each county. The `county_id` column uniquely identifies each county, linking the coefficients to specific counties. The `votes_coefficient` column provides the expected votes per resource unit, serving as a key component in the objective function.

- **DecisionVariables Table**: This table contains the decision variables representing the amount of resources allocated to each county. The `county_id` column uniquely identifies each county, linking the decision variables to specific counties. The `resource_allocation` column indicates the amount of resources allocated, serving as the decision variable in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical campaign resource allocation scenarios, ensuring that the budget and allocation constraints are realistic and align with common political campaign strategies.

-- Realistic data for ObjectiveCoefficients
INSERT INTO ObjectiveCoefficients (county_id, votes_coefficient) VALUES (1, 0.6);
INSERT INTO ObjectiveCoefficients (county_id, votes_coefficient) VALUES (2, 1.5);
INSERT INTO ObjectiveCoefficients (county_id, votes_coefficient) VALUES (3, 0.9);

-- Realistic data for DecisionVariables
INSERT INTO DecisionVariables (county_id, resource_allocation) VALUES (1, 800);
INSERT INTO DecisionVariables (county_id, resource_allocation) VALUES (2, 1500);
INSERT INTO DecisionVariables (county_id, resource_allocation) VALUES (3, 700);
```