# Complete Optimization Problem and Solution: Entrepreneur

## 1. Problem Context and Goals

### Context  
An investor is tasked with strategically allocating a fixed budget across a selection of entrepreneurs. The primary decision involves determining the amount of money to invest in each entrepreneur, with the goal of maximizing the expected return on investment. Each entrepreneur presents a unique opportunity, characterized by a specific expected return rate. The investor must consider the total budget available for investment, which serves as a constraint, ensuring that the sum of all investments does not exceed this budget. Additionally, each entrepreneur has a maximum amount they are willing to accept, which further constrains the investment decisions. The investor's objective is to maximize the total expected return, calculated as the sum of the products of each entrepreneur's expected return rate and the corresponding investment amount. This scenario is structured to align with a linear optimization formulation, focusing on precise decision-making within defined resource limitations.

### Goals  
The primary goal of this optimization problem is to maximize the total expected return from investments in various entrepreneurs. The metric for optimization is the total expected return, which is the sum of the expected return rates multiplied by the respective investment amounts for each entrepreneur. Success is measured by the ability to achieve the highest possible total expected return within the constraints of the available budget and the maximum amounts requested by the entrepreneurs. The optimization process is linear, focusing on maximizing the return while adhering to the defined constraints.

## 2. Constraints    

The investment strategy is subject to the following constraints:

- The total amount invested across all entrepreneurs must not exceed the total budget available for investment. This ensures that the investor operates within their financial means.
- The amount invested in each entrepreneur must not exceed the maximum amount requested by that entrepreneur. This constraint respects the individual limits set by each entrepreneur, ensuring that investments are realistic and acceptable.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data, modifying existing tables to improve mapping adequacy, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE Expected_Return_Coefficients (
  entrepreneur_id INTEGER,
  expected_return_rate FLOAT
);

CREATE TABLE Investments (
  entrepreneur_id INTEGER,
  amount FLOAT
);

CREATE TABLE Entrepreneur (
  entrepreneur_id INTEGER,
  Money_Requested FLOAT,
  expected_return_coefficient FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Expected_Return_Coefficients**: This table stores the expected return rates for each entrepreneur. The expected return rate serves as a coefficient in the objective function, linking the potential return to specific entrepreneurs.

  - **entrepreneur_id**: A unique identifier for each entrepreneur, used to associate return rates with specific individuals.
  - **expected_return_rate**: Represents the expected return rate for each entrepreneur, serving as a key factor in calculating the total expected return.

- **Investments**: This table tracks the amount of money invested in each entrepreneur. The investment amount is a decision variable in the optimization model.

  - **entrepreneur_id**: A unique identifier for each entrepreneur, linking investments to specific individuals.
  - **amount**: The amount of money invested in each entrepreneur, representing the decision variable in the optimization process.

- **Entrepreneur**: This table contains information about each entrepreneur, including the maximum amount they are willing to accept and their expected return rate.

  - **entrepreneur_id**: A unique identifier for each entrepreneur, serving as the primary key.
  - **Money_Requested**: The maximum amount requested by each entrepreneur, used as a constraint bound in the optimization model.
  - **expected_return_coefficient**: The expected return rate for each entrepreneur, used as an objective coefficient in the optimization process.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical investment scenarios where entrepreneurs request varying amounts and offer different expected returns. The total budget was set to allow for partial funding of all requests, ensuring a meaningful allocation decision.

-- Realistic data for Expected_Return_Coefficients
INSERT INTO Expected_Return_Coefficients (entrepreneur_id, expected_return_rate) VALUES (1, 0.12);
INSERT INTO Expected_Return_Coefficients (entrepreneur_id, expected_return_rate) VALUES (2, 0.18);
INSERT INTO Expected_Return_Coefficients (entrepreneur_id, expected_return_rate) VALUES (3, 0.22);

-- Realistic data for Investments
INSERT INTO Investments (entrepreneur_id, amount) VALUES (1, 15000);
INSERT INTO Investments (entrepreneur_id, amount) VALUES (2, 20000);
INSERT INTO Investments (entrepreneur_id, amount) VALUES (3, 25000);

-- Realistic data for Entrepreneur
INSERT INTO Entrepreneur (entrepreneur_id, Money_Requested, expected_return_coefficient) VALUES (1, 20000, 0.12);
INSERT INTO Entrepreneur (entrepreneur_id, Money_Requested, expected_return_coefficient) VALUES (2, 25000, 0.18);
INSERT INTO Entrepreneur (entrepreneur_id, Money_Requested, expected_return_coefficient) VALUES (3, 30000, 0.22);
```