# Complete Optimization Problem and Solution: flight_company

## 1. Problem Context and Goals

### Context  
The flight company is focused on optimizing the allocation of its flights to various airports to minimize the overall operational costs. The decision-making process involves determining whether a flight should be assigned to a specific airport, represented by a binary decision variable. The operational costs are influenced by the distance between the flight's origin and the airport, as well as the fee rate charged by the airport. The company aims to ensure that each flight is assigned to exactly one airport, and that no airport exceeds its capacity to handle flights. The cost of assigning a flight to an airport is calculated by multiplying the distance by the fee rate, which serves as the basis for the objective coefficients in the optimization model. This approach ensures that the problem remains linear, avoiding any nonlinear relationships such as variable products or divisions. The business configuration includes both scalar parameters and business logic formulas, ensuring consistency and flexibility in parameter tuning.

### Goals  
The primary goal of the optimization is to minimize the total operational cost associated with assigning flights to airports. This involves reducing the sum of costs calculated by multiplying the distance and fee rate for each flight-airport assignment. Success in this optimization is measured by achieving the lowest possible total cost while adhering to the constraints of flight assignments and airport capacities. The objective is clearly defined in linear terms, focusing on minimizing the total cost without involving any complex mathematical expressions.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the feasibility and practicality of the solution:

- Each flight must be assigned to exactly one airport. This ensures that all flights are accounted for and properly managed within the system.
- The total number of flights assigned to an airport must not exceed its capacity. This constraint ensures that airports operate within their limits, maintaining efficient and safe operations.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains straightforward and solvable using linear programming techniques.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include adding tables for distance and fee rate data, updating business configuration logic for cost coefficient formula, and ensuring all tables have at least 3 rows of data.

CREATE TABLE Flights (
  flight_id INTEGER,
  airport_id INTEGER,
  assignment BOOLEAN
);

CREATE TABLE Airports (
  airport_id INTEGER,
  capacity INTEGER
);

CREATE TABLE Distances (
  flight_id INTEGER,
  airport_id INTEGER,
  distance FLOAT
);

CREATE TABLE FeeRates (
  airport_id INTEGER,
  fee_rate FLOAT
);


```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns, explaining their business purposes and roles in the optimization process:

- **Flights Table**: Represents the assignment of flights to airports. It includes:
  - `flight_id`: A unique identifier for each flight, used to identify flights in the optimization model.
  - `airport_id`: An identifier for the assigned airport, linking flights to airports in the optimization model.
  - `assignment`: A boolean indicating if a flight is assigned to an airport, serving as a decision variable in the optimization model.

- **Airports Table**: Contains data about airports, including their capacity. It includes:
  - `airport_id`: A unique identifier for each airport, used to identify airports in the optimization model.
  - `capacity`: The maximum number of flights an airport can handle, serving as a constraint bound in the optimization model.

- **Distances Table**: Represents the distance between each flight and airport for cost calculation. It includes:
  - `flight_id`: A unique identifier for each flight, used in cost calculation.
  - `airport_id`: An identifier for the airport, used in cost calculation.
  - `distance`: The distance between the flight and airport, used in cost calculation.

- **FeeRates Table**: Represents the fee rate for each airport for cost calculation. It includes:
  - `airport_id`: An identifier for the airport, used in cost calculation.
  - `fee_rate`: The fee rate for using the airport, used in cost calculation.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical distances between major airports and realistic fee rates charged by airports. Capacities were set to reflect typical airport operations, ensuring a balance between demand and supply.

-- Realistic data for Flights
INSERT INTO Flights (flight_id, airport_id, assignment) VALUES (1, 101, True);
INSERT INTO Flights (flight_id, airport_id, assignment) VALUES (2, 102, True);
INSERT INTO Flights (flight_id, airport_id, assignment) VALUES (3, 103, True);

-- Realistic data for Airports
INSERT INTO Airports (airport_id, capacity) VALUES (101, 120);
INSERT INTO Airports (airport_id, capacity) VALUES (102, 180);
INSERT INTO Airports (airport_id, capacity) VALUES (103, 150);

-- Realistic data for Distances
INSERT INTO Distances (flight_id, airport_id, distance) VALUES (1, 101, 550.0);
INSERT INTO Distances (flight_id, airport_id, distance) VALUES (2, 102, 800.0);
INSERT INTO Distances (flight_id, airport_id, distance) VALUES (3, 103, 950.0);

-- Realistic data for FeeRates
INSERT INTO FeeRates (airport_id, fee_rate) VALUES (101, 12.0);
INSERT INTO FeeRates (airport_id, fee_rate) VALUES (102, 18.0);
INSERT INTO FeeRates (airport_id, fee_rate) VALUES (103, 22.0);


```