# Complete Optimization Problem and Solution: game_1

## 1. Problem Context and Goals

### Context  
The university is focused on optimizing how students allocate their time between playing video games and participating in sports. The aim is to enhance student engagement while ensuring that academic responsibilities are not neglected. The decision variables in this context are the hours students allocate to games and sports, represented as continuous variables. Specifically, x[StuID, GameID] denotes the hours a student allocates to a particular game, and y[StuID, SportName] represents the hours allocated to a specific sport. The operational parameters are designed to align with the objective of maximizing total engagement. This involves summing the product of game engagement scores and hours allocated to games, along with the product of sport engagement scores and hours allocated to sports. The business configuration includes constraints such as the total hours a student can allocate to games and sports, the minimum hours a student on scholarship must spend on sports, and the maximum hours a student can spend on games. These constraints ensure that the allocation of time is balanced and adheres to the university's academic and extracurricular policies.

### Goals  
The primary goal of this optimization problem is to maximize student engagement. This is achieved by optimizing the allocation of hours to games and sports in a way that maximizes the total engagement score. The engagement score is calculated by summing the products of game engagement scores with the hours allocated to games and sport engagement scores with the hours allocated to sports. Success in this optimization is measured by the total engagement score, which reflects the effectiveness of the time allocation in enhancing student engagement. The objective is clearly defined in linear terms, focusing on maximizing this engagement score without involving any nonlinear relationships.

## 2. Constraints    

The constraints in this optimization problem are designed to ensure that the allocation of time adheres to the university's policies and supports student success. The first constraint ensures that the total hours a student allocates to games and sports do not exceed the available hours, reflecting a balanced schedule. The second constraint mandates that students on scholarships spend a minimum number of hours on sports, ensuring they meet participation requirements. The third constraint limits the hours a student can spend on games, preventing excessive gaming and promoting academic focus. These constraints are expressed in linear terms, directly aligning with the expected mathematical formulation.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating new tables for decision variables, modifying existing tables to improve mapping adequacy, and moving scalar parameters to configuration logic.

CREATE TABLE EngagementScores (
  StuID INTEGER,
  GameID INTEGER,
  SportName STRING,
  GameEngagementScore FLOAT,
  SportEngagementScore FLOAT
);

CREATE TABLE GameAllocation (
  StuID INTEGER,
  GameID INTEGER,
  HoursAllocated FLOAT
);

CREATE TABLE SportAllocation (
  StuID INTEGER,
  SportName STRING,
  HoursAllocated FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in this optimization problem, mapping them to their business purposes and roles in the optimization process. 

- **EngagementScores**: This table stores the engagement scores for each student, game, and sport. The engagement scores serve as coefficients in the objective function, linking the scores to the students, games, and sports.
  - **StuID**: Represents the student identifier, linking engagement scores to individual students.
  - **GameID**: Represents the game identifier, linking engagement scores to specific games.
  - **SportName**: Represents the name of the sport, linking engagement scores to specific sports.
  - **GameEngagementScore**: Represents the engagement score for games, used as a coefficient in the objective function.
  - **SportEngagementScore**: Represents the engagement score for sports, used as a coefficient in the objective function.

- **GameAllocation**: This table records the hours students allocate to games, serving as decision variables in the optimization model.
  - **StuID**: Represents the student identifier, linking allocation to individual students.
  - **GameID**: Represents the game identifier, linking allocation to specific games.
  - **HoursAllocated**: Represents the hours allocated by a student to a game, serving as a decision variable.

- **SportAllocation**: This table records the hours students allocate to sports, serving as decision variables in the optimization model.
  - **StuID**: Represents the student identifier, linking allocation to individual students.
  - **SportName**: Represents the name of the sport, linking allocation to specific sports.
  - **HoursAllocated**: Represents the hours allocated by a student to a sport, serving as a decision variable.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical student schedules, engagement levels, and scholarship requirements to ensure a balanced allocation between games and sports.

-- Realistic data for EngagementScores
INSERT INTO EngagementScores (StuID, GameID, SportName, GameEngagementScore, SportEngagementScore) VALUES (1, 101, 'Basketball', 1.8, 1.5);
INSERT INTO EngagementScores (StuID, GameID, SportName, GameEngagementScore, SportEngagementScore) VALUES (2, 102, 'Soccer', 2.2, 1.8);
INSERT INTO EngagementScores (StuID, GameID, SportName, GameEngagementScore, SportEngagementScore) VALUES (3, 103, 'Tennis', 1.5, 2.0);

-- Realistic data for GameAllocation
INSERT INTO GameAllocation (StuID, GameID, HoursAllocated) VALUES (1, 101, 10.0);
INSERT INTO GameAllocation (StuID, GameID, HoursAllocated) VALUES (2, 102, 12.0);
INSERT INTO GameAllocation (StuID, GameID, HoursAllocated) VALUES (3, 103, 8.0);

-- Realistic data for SportAllocation
INSERT INTO SportAllocation (StuID, SportName, HoursAllocated) VALUES (1, 'Basketball', 8.0);
INSERT INTO SportAllocation (StuID, SportName, HoursAllocated) VALUES (2, 'Soccer', 6.0);
INSERT INTO SportAllocation (StuID, SportName, HoursAllocated) VALUES (3, 'Tennis', 10.0);
```