# Complete Optimization Problem and Solution: game_injury

## 1. Problem Context and Goals

### Context  
The sports league is focused on optimizing the scheduling of its games to achieve the highest possible attendance while minimizing the risk of player injuries. The league's decision-making process involves determining the number of home games to be played at each stadium and deciding which games to schedule, ensuring that these decisions align with the league's operational parameters. The primary decision variables include the number of home games scheduled at each stadium, represented as an integer, and the scheduling of games, represented as a binary decision. The league aims to maximize total attendance by considering the average attendance expected at each stadium and minimizing the injury risk associated with each game. The business configuration includes parameters such as the total number of home games that can be scheduled, which serves as a constraint bound, and the maximum allowable injury risk for scheduling, ensuring player safety while maintaining competitive play.

### Goals  
The primary goal of the optimization is to maximize the total attendance across all scheduled games. This involves leveraging the average attendance figures for each stadium and minimizing the injury risk associated with each game. The success of this optimization is measured by the total attendance achieved, which is calculated by considering the average attendance at each stadium and the injury risk for each game. The optimization goal is clearly defined in natural language, focusing on maximizing attendance while adhering to the constraints set by the league's operational parameters.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the feasibility and practicality of the scheduling decisions:

- The total number of home games scheduled across all stadiums must not exceed the league's predefined limit, ensuring a balanced distribution of games.
- The cumulative injury risk associated with the scheduled games must remain within the maximum allowable limit, prioritizing player safety.
- The number of home games scheduled at each stadium must not exceed the stadium's capacity, as determined by a percentage of the total home games allowed, ensuring that each stadium operates within its capacity limits.

These constraints are articulated in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding missing tables for injury risk and game schedule, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE stadium (
  Average_Attendance INTEGER,
  Capacity_Percentage FLOAT,
  Home_Games INTEGER
);

CREATE TABLE injury_risk (
  Risk FLOAT
);

CREATE TABLE game_schedule (
  Scheduled BOOLEAN
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of the tables and columns to their business purposes and roles in the optimization process:

- **Stadium Table**: This table contains information about each stadium, including the average attendance expected, the maximum capacity utilization allowed, and the number of home games scheduled. The average attendance is used in the objective function to calculate total attendance, while the capacity percentage is used to limit the number of home games.

- **Injury Risk Table**: This table stores the risk of injury associated with each game. The injury risk is a critical factor in the objective function, as it is used to minimize injuries while scheduling games.

- **Game Schedule Table**: This table indicates whether a game is scheduled. The scheduled column is a binary variable that serves as a decision variable for game scheduling.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical stadium capacities, average attendance figures, and realistic injury risks in sports leagues. The approach ensures that the optimization problem is both meaningful and solvable by balancing attendance and injury risk.

-- Realistic data for stadium
INSERT INTO stadium (Average_Attendance, Capacity_Percentage, Home_Games) VALUES (8000, 0.85, 6);
INSERT INTO stadium (Average_Attendance, Capacity_Percentage, Home_Games) VALUES (12000, 0.9, 8);
INSERT INTO stadium (Average_Attendance, Capacity_Percentage, Home_Games) VALUES (15000, 0.95, 6);

-- Realistic data for injury_risk
INSERT INTO injury_risk (Risk) VALUES (0.02);
INSERT INTO injury_risk (Risk) VALUES (0.03);
INSERT INTO injury_risk (Risk) VALUES (0.04);
INSERT INTO injury_risk (Risk) VALUES (0.01);
INSERT INTO injury_risk (Risk) VALUES (0.05);

-- Realistic data for game_schedule
INSERT INTO game_schedule (Scheduled) VALUES (True);
INSERT INTO game_schedule (Scheduled) VALUES (False);
INSERT INTO game_schedule (Scheduled) VALUES (True);
INSERT INTO game_schedule (Scheduled) VALUES (False);
INSERT INTO game_schedule (Scheduled) VALUES (True);
```