# Complete Optimization Problem and Solution: gymnast

## 1. Problem Context and Goals

### Context  
The gymnastics competition organizer aims to strategically allocate gymnasts to various events to maximize the total points scored. Each gymnast's participation in an event is a binary decision, indicating whether they participate or not. The operational goal is to maximize the total points accumulated from all events, which include Floor Exercise, Pommel Horse, Rings, Vault, Parallel Bars, and Horizontal Bar. The points scored in each event are multiplied by the participation decision for each gymnast. The business configuration includes constraints such as the maximum number of events a single gymnast can participate in, and the maximum number of gymnasts allowed to participate in a single event. These constraints ensure that the competition remains fair and manageable, aligning with the linear optimization model requirements. The configuration parameters are set to realistic values based on typical competition structures and physical demands on gymnasts.

### Goals  
The primary goal is to maximize the total points scored by gymnasts across all events. This involves optimizing the allocation of gymnasts to events, ensuring that the total points from Floor Exercise, Pommel Horse, Rings, Vault, Parallel Bars, and Horizontal Bar are maximized. The success of this optimization is measured by the total points achieved, which directly correlates with the participation decisions and the points scored in each event. The objective is clearly defined in linear terms, focusing on maximizing the sum of points across all events.

## 2. Constraints    

The optimization problem is subject to specific constraints to ensure feasibility and fairness. Each gymnast can participate in a limited number of events, defined by the maximum events per gymnast constraint. Additionally, each event can accommodate a limited number of gymnasts, as specified by the maximum gymnasts per event constraint. These constraints are designed to maintain a balanced competition and are expressed in linear terms, aligning with the business requirements and ensuring that the optimization model remains linear.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for decision variables and constraint bounds, and moving scalar parameters to configuration logic. Adjustments ensure alignment with OR expert's requirements and optimization model.

CREATE TABLE gymnast (
  Floor_Exercise_Points INTEGER,
  Pommel_Horse_Points INTEGER,
  Rings_Points INTEGER,
  Vault_Points INTEGER,
  Parallel_Bars_Points INTEGER,
  Horizontal_Bar_Points INTEGER
);

CREATE TABLE decision_variables (
  participation BOOLEAN
);

CREATE TABLE constraint_bounds (
  max_events_per_gymnast INTEGER,
  max_gymnasts_per_event INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and roles in the optimization model:

- **Gymnast Table**: This table stores the performance data of gymnasts across different events. Each column represents the points scored by a gymnast in a specific event, serving as coefficients in the optimization objective.
  - **Floor Exercise Points**: Points scored in the Floor Exercise event.
  - **Pommel Horse Points**: Points scored in the Pommel Horse event.
  - **Rings Points**: Points scored in the Rings event.
  - **Vault Points**: Points scored in the Vault event.
  - **Parallel Bars Points**: Points scored in the Parallel Bars event.
  - **Horizontal Bar Points**: Points scored in the Horizontal Bar event.

- **Decision Variables Table**: This table captures the participation decisions for each gymnast, indicating whether they participate in an event.
  - **Participation**: A binary indicator of a gymnast's participation in an event.

- **Constraint Bounds Table**: This table defines the constraints for the optimization model, specifying the maximum number of events a gymnast can participate in and the maximum number of gymnasts per event.
  - **Max Events Per Gymnast**: The upper limit on the number of events a single gymnast can participate in.
  - **Max Gymnasts Per Event**: The upper limit on the number of gymnasts allowed in a single event.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical scoring ranges in gymnastics competitions and realistic participation constraints to ensure a balanced and competitive event setup.

-- Realistic data for gymnast
INSERT INTO gymnast (Floor_Exercise_Points, Pommel_Horse_Points, Rings_Points, Vault_Points, Parallel_Bars_Points, Horizontal_Bar_Points) VALUES (12, 10, 14, 15, 11, 9);
INSERT INTO gymnast (Floor_Exercise_Points, Pommel_Horse_Points, Rings_Points, Vault_Points, Parallel_Bars_Points, Horizontal_Bar_Points) VALUES (18, 16, 17, 19, 14, 13);
INSERT INTO gymnast (Floor_Exercise_Points, Pommel_Horse_Points, Rings_Points, Vault_Points, Parallel_Bars_Points, Horizontal_Bar_Points) VALUES (14, 12, 15, 17, 13, 11);

-- Realistic data for decision_variables
INSERT INTO decision_variables (participation) VALUES (True);
INSERT INTO decision_variables (participation) VALUES (False);
INSERT INTO decision_variables (participation) VALUES (True);

-- Realistic data for constraint_bounds
INSERT INTO constraint_bounds (max_events_per_gymnast, max_gymnasts_per_event) VALUES (3, 5);
```