# Complete Optimization Problem and Solution: icfp_1

## 1. Problem Context and Goals

### Context  
The conference is organizing a series of paper presentations and aims to optimize the scheduling process. The primary decision involves determining whether a paper is scheduled in a particular session, represented by a binary decision variable. The objective is to minimize the total number of sessions required to present all papers. Each session can accommodate a limited number of papers, and no author should present more than one paper in the same session. The business configuration includes a parameter specifying the maximum number of papers that can be scheduled in a single session, which serves as a constraint in the optimization model. The focus is on making precise operational decisions that align with linear formulations, ensuring resource limitations are respected without involving nonlinear relationships.

### Goals  
The optimization goal is to minimize the total number of sessions needed for the conference. The metric to optimize is the total number of sessions, which is directly related to the decision of scheduling papers into sessions. Success is measured by achieving the minimum possible number of sessions while adhering to the constraints. The goal is articulated in natural language to ensure clarity and alignment with the linear optimization objective.

## 2. Constraints    

The constraints for the scheduling problem are as follows:

- Each paper must be scheduled in exactly one session. This ensures that every paper is presented once during the conference.
- The number of papers scheduled in any session cannot exceed the maximum number of papers allowed per session. This constraint ensures that sessions are not overloaded beyond their capacity.
- An author cannot present more than one paper in the same session. This constraint prevents scheduling conflicts for authors who have multiple papers.

These constraints are described in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for decision variables and author-paper associations, and updating configuration logic for session constraints.

CREATE TABLE Papers (
  paper_id INTEGER,
  title STRING
);

CREATE TABLE Authors (
  author_id INTEGER,
  name STRING
);

CREATE TABLE AuthorPaperAssociations (
  author_id INTEGER,
  paper_id INTEGER
);

CREATE TABLE Sessions (
  session_id INTEGER,
  paper_id INTEGER
);
```

### Data Dictionary  
The data dictionary provides a business-oriented mapping of tables and columns to their purposes and roles in the optimization process:

- **Papers Table**: Stores information about each paper, including a unique identifier and the title. This data is crucial for identifying papers in the scheduling decision variables.
  
- **Authors Table**: Contains details about each author, including a unique identifier and name. This information is used to ensure that authors do not have scheduling conflicts.

- **AuthorPaperAssociations Table**: Links authors to their respective papers, facilitating the enforcement of constraints related to author scheduling.

- **Sessions Table**: Represents the scheduling of papers into sessions, with each entry indicating a paper scheduled in a specific session. This table is central to the decision-making process for paper scheduling.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical conference settings, ensuring a balance between the number of papers, authors, and sessions to create a realistic scheduling scenario.

-- Realistic data for Papers
INSERT INTO Papers (paper_id, title) VALUES (1, 'Advances in AI');
INSERT INTO Papers (paper_id, title) VALUES (2, 'Quantum Computing');
INSERT INTO Papers (paper_id, title) VALUES (3, 'Blockchain Technology');

-- Realistic data for Authors
INSERT INTO Authors (author_id, name) VALUES (1, 'Dr. Alice Smith');
INSERT INTO Authors (author_id, name) VALUES (2, 'Dr. Bob Johnson');
INSERT INTO Authors (author_id, name) VALUES (3, 'Dr. Carol Williams');

-- Realistic data for AuthorPaperAssociations
INSERT INTO AuthorPaperAssociations (author_id, paper_id) VALUES (1, 1);
INSERT INTO AuthorPaperAssociations (author_id, paper_id) VALUES (2, 2);
INSERT INTO AuthorPaperAssociations (author_id, paper_id) VALUES (3, 3);

-- Realistic data for Sessions
INSERT INTO Sessions (session_id, paper_id) VALUES (1, 1);
INSERT INTO Sessions (session_id, paper_id) VALUES (2, 2);
INSERT INTO Sessions (session_id, paper_id) VALUES (3, 3);
```