# Complete Optimization Problem and Solution: manufacturer

## 1. Problem Context and Goals

### Context  
The furniture manufacturer is focused on maximizing its profit by strategically determining the optimal number of furniture items to produce and sell. This decision-making process involves evaluating the market rates and production costs associated with each furniture item. The manufacturer operates under specific capacity constraints, which include the total production capacity determined by the number of factories and the total sales capacity dictated by the number of shops. These constraints are crucial in ensuring that the production and sales activities remain within feasible limits. The business decisions revolve around selecting the quantity of each furniture item to produce and sell, where each quantity is an integer value. The operational parameters are aligned with the objective of maximizing total profit, calculated as the difference between market rates and production costs, multiplied by the quantity of items produced and sold. The business configuration includes scalar parameters such as total production capacity and total sales capacity, which serve as bounds in the optimization model. The focus is on precise operational decision-making that leads to a linear optimization formulation, avoiding any scenarios that would require nonlinear relationships.

### Goals  
The primary goal of the optimization is to maximize the total profit for the furniture manufacturer. This involves determining the optimal quantities of furniture items to produce and sell, with the aim of maximizing the difference between the market rates and production costs for each item. The success of this optimization is measured by the total profit achieved, which is calculated by summing the product of the profit margin (market rate minus production cost) and the quantity of each item. The optimization goal is clearly defined in linear terms, ensuring that the decision-making process is straightforward and aligned with the expected linear mathematical formulation.

## 2. Constraints    

The optimization process is subject to two key constraints that ensure the feasibility of the production and sales activities. The first constraint is the total production capacity, which limits the sum of the quantities of all furniture items to not exceed the maximum output capacity of the manufacturing facilities. This capacity is determined by the number of factories available. The second constraint is the total sales capacity, which restricts the sum of the quantities of all furniture items to not surpass the maximum sales capacity across all retail outlets. This capacity is based on the number of shops. Both constraints are expressed in linear terms, directly aligning with the business requirements and ensuring that the optimization remains within realistic operational limits.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating a new table for decision variables, updating existing tables to include missing mappings, and moving scalar parameters to configuration logic. This addresses the OR expert's mapping gaps and ensures all optimization requirements are met.

CREATE TABLE furniture (
  market_rate FLOAT,
  price_in_dollar FLOAT,
  quantity INTEGER
);

CREATE TABLE decision_variables (
  quantity INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of the tables and columns to their respective business purposes and optimization roles. The "furniture" table stores critical information about each furniture item, including its market rate and production cost. These values are essential for calculating the profit margin for each item. The "quantity" column in this table represents the number of units of each furniture item to produce and sell, serving as a decision variable in the optimization process. The "decision_variables" table is specifically designed to store the decision variables for optimization, with the "quantity" column indicating the number of units to produce and sell for each item. This structure ensures a clear connection to the expected linear mathematical formulation, facilitating effective decision-making.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical market rates and production costs for furniture items, ensuring a balance between profitability and capacity constraints.

-- Realistic data for furniture
INSERT INTO furniture (market_rate, price_in_dollar, quantity) VALUES (120.0, 60.0, 15);
INSERT INTO furniture (market_rate, price_in_dollar, quantity) VALUES (180.0, 90.0, 10);
INSERT INTO furniture (market_rate, price_in_dollar, quantity) VALUES (140.0, 70.0, 20);

-- Realistic data for decision_variables
INSERT INTO decision_variables (quantity) VALUES (15);
INSERT INTO decision_variables (quantity) VALUES (10);
INSERT INTO decision_variables (quantity) VALUES (20);
```