# Complete Optimization Problem and Solution: mountain_photos

## 1. Problem Context and Goals

### Context  
A photography company is in the process of curating a selection of photos for a new mountain photography book. The primary objective is to enhance the visual diversity of the book by selecting photos that showcase a variety of colors and different mountains. The decision-making process involves selecting photos, where each photo is represented by a binary decision variable. This variable indicates whether a photo is included in the final selection or not. The operational goal is to maximize the total diversity score of the selected photos. Each photo has an associated diversity score, which reflects its contribution to the overall diversity of the book.

The business configuration includes specific constraints: the total number of photos that can be included in the book is limited, and there is also a restriction on the number of photos that can be selected from each individual mountain. These constraints ensure that the book remains manageable in size and that no single mountain dominates the content, thereby promoting a balanced representation of different mountains.

### Goals  
The optimization goal is to maximize the diversity of the selected photos. This is achieved by focusing on the sum of the diversity scores of the photos that are chosen for inclusion in the book. The success of this optimization is measured by the total diversity score, which is derived from the diversity scores of the individual photos selected. The aim is to select photos in such a way that the overall diversity score is maximized, while adhering to the constraints on the total number of photos and the number of photos per mountain.

## 2. Constraints    

The selection process is subject to two primary constraints. First, there is a limit on the total number of photos that can be included in the book. This ensures that the book remains concise and focused. Second, there is a constraint on the number of photos that can be selected from each mountain. This constraint is in place to ensure that the book features a diverse range of mountains, preventing any single mountain from being overrepresented. These constraints are designed to naturally align with linear mathematical formulations, ensuring a straightforward optimization process.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating a new table for diversity scores and updating business configuration logic for constraints. These changes address the OR expert's mapping gaps and missing requirements.

CREATE TABLE photos (
  id INTEGER,
  diversity_score FLOAT
);

CREATE TABLE photo_diversity_scores (
  photo_id INTEGER,
  diversity_score FLOAT
);
```

### Data Dictionary  
The data is organized into tables that serve specific business purposes and optimization roles:

- **Photos Table**: This table contains information about each photo. It includes:
  - **ID**: A unique identifier for each photo, used as a decision variable in the optimization process.
  - **Diversity Score**: A numerical value representing the diversity of the photo, based on its color and the mountain it depicts. This score is used as an objective coefficient in the optimization.

- **Photo Diversity Scores Table**: This table stores the diversity scores for each photo, linking them to their respective photo IDs. The diversity score is crucial for determining the contribution of each photo to the overall diversity of the book.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical constraints and diversity requirements for a photography book, ensuring a balance between diversity and selection limits.

-- Realistic data for photos
INSERT INTO photos (id, diversity_score) VALUES (1, 0.85);
INSERT INTO photos (id, diversity_score) VALUES (2, 0.75);
INSERT INTO photos (id, diversity_score) VALUES (3, 0.9);
INSERT INTO photos (id, diversity_score) VALUES (4, 0.65);
INSERT INTO photos (id, diversity_score) VALUES (5, 0.8);

-- Realistic data for photo_diversity_scores
INSERT INTO photo_diversity_scores (photo_id, diversity_score) VALUES (1, 0.85);
INSERT INTO photo_diversity_scores (photo_id, diversity_score) VALUES (2, 0.75);
INSERT INTO photo_diversity_scores (photo_id, diversity_score) VALUES (3, 0.9);
INSERT INTO photo_diversity_scores (photo_id, diversity_score) VALUES (4, 0.65);
INSERT INTO photo_diversity_scores (photo_id, diversity_score) VALUES (5, 0.8);
```