# Complete Optimization Problem and Solution: museum_visit

## 1. Problem Context and Goals

### Context  
The museum network aims to optimize the allocation of its staff across various museums to enhance visitor satisfaction while controlling operational costs. The decision involves determining the number of staff members to allocate to each museum, where the number of staff is an integer. The operational parameters are designed to align with a linear objective: maximizing total visitor satisfaction, which is directly proportional to the number of staff allocated, while minimizing the total operational cost, which is also a linear function of the staff allocation.

The business configuration includes several key parameters:
- The total number of staff available for allocation across all museums, which serves as a constraint in the optimization model.
- The minimum number of staff required for each museum to ensure effective operation, also used as a constraint.
- The maximum staff capacity for each museum to prevent overstaffing and ensure operational efficiency.

These parameters are crucial for maintaining a balance between resource allocation and operational efficiency. The current operational information reflects these constraints and objectives, ensuring that the decision-making process is precise and leads to a linear formulation. The resource limitations are clearly defined to match the expected linear constraints, avoiding any scenarios that would require nonlinear relationships. The specific operational parameters are mapped to the expected coefficient sources, ensuring consistency and clarity in the optimization process.

### Goals  
The primary goal of this optimization problem is to maximize the total visitor satisfaction across all museums. This is achieved by strategically allocating staff to each museum, where the satisfaction is assumed to increase linearly with the number of staff members. The optimization metric is to maximize the total visitor satisfaction, which is calculated as the sum of the satisfaction coefficients multiplied by the staff allocated to each museum, minus the sum of the cost coefficients multiplied by the staff allocated. Success in this optimization is measured by the alignment with the expected coefficient sources, ensuring that the linear optimization goal is clearly defined and achievable.

## 2. Constraints    

The optimization problem is subject to several constraints that are directly aligned with linear mathematical forms:
- The total number of staff allocated across all museums must not exceed the total available staff. This ensures that the allocation does not surpass the staffing resources available.
- Each museum must have a number of staff allocated that is at least the minimum required for effective operation and does not exceed the maximum capacity. This constraint ensures that each museum operates efficiently without overstaffing.

These constraints are described in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains within the realm of linear programming.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for objective coefficients and constraint bounds, modifying existing tables to address mapping gaps, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE museum (
  Num_of_Staff INTEGER,
  satisfaction_coefficient FLOAT,
  cost_coefficient FLOAT
);

CREATE TABLE ObjectiveCoefficients (
  museum_id INTEGER,
  satisfaction_coefficient FLOAT,
  cost_coefficient FLOAT
);

CREATE TABLE ConstraintBounds (
  museum_id INTEGER,
  minimum_staff_required INTEGER,
  maximum_staff_capacity INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Museum Table**: This table stores information about each museum, including the number of staff allocated and the coefficients related to visitor satisfaction and operational cost. The number of staff allocated is a decision variable, while the satisfaction and cost coefficients are used in the objective function.

- **ObjectiveCoefficients Table**: This table contains the coefficients used in the optimization objectives. Each entry links a museum to its respective satisfaction and cost coefficients, which are crucial for calculating the optimization goal.

- **ConstraintBounds Table**: This table defines the bounds for staff allocation constraints. It specifies the minimum and maximum number of staff required for each museum, ensuring that the allocation adheres to operational requirements.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical staffing needs and operational costs for museums of varying sizes, ensuring a balance between visitor satisfaction and cost efficiency.

-- Realistic data for museum
INSERT INTO museum (Num_of_Staff, satisfaction_coefficient, cost_coefficient) VALUES (8, 1.3, 0.9);
INSERT INTO museum (Num_of_Staff, satisfaction_coefficient, cost_coefficient) VALUES (12, 1.6, 1.1);
INSERT INTO museum (Num_of_Staff, satisfaction_coefficient, cost_coefficient) VALUES (6, 1.2, 0.8);

-- Realistic data for ObjectiveCoefficients
INSERT INTO ObjectiveCoefficients (museum_id, satisfaction_coefficient, cost_coefficient) VALUES (1, 1.3, 0.9);
INSERT INTO ObjectiveCoefficients (museum_id, satisfaction_coefficient, cost_coefficient) VALUES (2, 1.6, 1.1);
INSERT INTO ObjectiveCoefficients (museum_id, satisfaction_coefficient, cost_coefficient) VALUES (3, 1.2, 0.8);

-- Realistic data for ConstraintBounds
INSERT INTO ConstraintBounds (museum_id, minimum_staff_required, maximum_staff_capacity) VALUES (1, 5, 15);
INSERT INTO ConstraintBounds (museum_id, minimum_staff_required, maximum_staff_capacity) VALUES (2, 7, 20);
INSERT INTO ConstraintBounds (museum_id, minimum_staff_required, maximum_staff_capacity) VALUES (3, 4, 10);
```