# Complete DOCPLEX implementation - Retry Attempt 1

from docplex.mp.model import Model

def music_festival_optimization():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="music_festival")
    
    # Data from the problem statement
    artist_ids = [1, 2, 3]
    weeks_on_top = [12, 8, 15]
    availability_status = [True, False, True]
    capacity = 2
    
    # CRITICAL: Validate array lengths to prevent IndexError
    assert len(artist_ids) == len(weeks_on_top) == len(availability_status), "Array length mismatch"
    safe_range = range(len(artist_ids))  # Safe indexing
    
    # 2. VARIABLES
    x = {i: mdl.binary_var(name=f"x_{artist_ids[i]}") for i in safe_range}
    
    # 3. OBJECTIVE FUNCTION
    objective = mdl.sum(weeks_on_top[i] * x[i] for i in safe_range)
    mdl.maximize(objective)
    
    # 4. CONSTRAINTS - CORRECT SYNTAX PATTERNS
    
    # Capacity Constraint
    mdl.add_constraint(mdl.sum(x[i] for i in safe_range) <= capacity, ctname="capacity_constraint")
    
    # Availability Constraints
    for i in safe_range:
        # Convert boolean to integer for constraint compatibility
        availability = 1 if availability_status[i] else 0
        mdl.add_constraint(x[i] <= availability, ctname=f"availability_{artist_ids[i]}")
    
    # 5. SOLVING & RESULTS
    solution = mdl.solve()
    
    if solution:
        print(f"Optimal value: {solution.objective_value}")
        for i in safe_range:
            value = solution.get_value(x[i])
            if value > 0.5:  # Since x[i] is binary, check if selected
                print(f"Artist {artist_ids[i]} is selected.")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")

# Run the optimization
music_festival_optimization()