# Complete Optimization Problem and Solution: music_4

## 1. Problem Context and Goals

### Context  
The music festival organizer is tasked with selecting a set of artists to perform at an upcoming festival. The primary decision involves choosing which artists to invite, where each artist's selection is represented by a binary decision variable. The goal is to maximize the festival's exposure by selecting artists who have spent the most weeks at the top of the music charts. This decision-making process is constrained by the festival's capacity, which limits the number of artists that can be invited, and the availability of each artist on the festival date.

The operational parameters are straightforward: the objective is to maximize the total number of weeks the selected artists have been on top of the charts. This is achieved by summing the product of each artist's weeks on top and their selection status. The festival's capacity acts as a constraint, ensuring that the number of selected artists does not exceed the venue's limit. Additionally, only artists who are available on the festival date can be selected.

### Goals  
The optimization goal is to maximize the festival's exposure by selecting artists who have the highest cumulative weeks on top of the charts. The metric for optimization is the total weeks on top, calculated by summing the weeks on top for each selected artist. Success is measured by the total exposure achieved, aligning with the objective of maximizing the festival's impact through artist selection.

## 2. Constraints    

The selection of artists is subject to two primary constraints. First, the total number of artists selected must not exceed the festival's capacity. This ensures that the festival remains within logistical and operational limits. Second, an artist can only be selected if they are available on the festival date. These constraints are designed to ensure that the selection process is both feasible and aligned with the festival's operational requirements.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added Weeks_on_Top table to address missing data for objective coefficients, updated data dictionary, and adjusted business configuration logic for scalar parameters.

CREATE TABLE artist (
  Artist_ID INTEGER,
  Availability_Status BOOLEAN
);

CREATE TABLE artist_weeks_on_top (
  Artist_ID INTEGER,
  Weeks_on_Top INTEGER
);

CREATE TABLE festival_capacity (
  Capacity INTEGER
);
```

### Data Dictionary  
- **Artist Table**: This table contains information about each artist, including a unique identifier and their availability status. The availability status indicates whether an artist is available to perform on the festival date, which is crucial for ensuring that only available artists are considered for selection.

- **Artist Weeks on Top Table**: This table records the number of weeks each artist has been at the top of the music charts. This data serves as the basis for the optimization objective, as it reflects the potential exposure each artist can bring to the festival.

- **Festival Capacity Table**: This table defines the maximum number of artists that can be selected for the festival. It serves as a constraint in the optimization model, ensuring that the number of selected artists does not exceed the festival's logistical capacity.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical festival capacities, artist popularity metrics, and availability patterns observed in the music industry.

-- Realistic data for artist
INSERT INTO artist (Artist_ID, Availability_Status) VALUES (1, True);
INSERT INTO artist (Artist_ID, Availability_Status) VALUES (2, False);
INSERT INTO artist (Artist_ID, Availability_Status) VALUES (3, True);

-- Realistic data for artist_weeks_on_top
INSERT INTO artist_weeks_on_top (Artist_ID, Weeks_on_Top) VALUES (1, 12);
INSERT INTO artist_weeks_on_top (Artist_ID, Weeks_on_Top) VALUES (2, 8);
INSERT INTO artist_weeks_on_top (Artist_ID, Weeks_on_Top) VALUES (3, 15);

-- Realistic data for festival_capacity
INSERT INTO festival_capacity (Capacity) VALUES (2);
```