# Complete DOCPLEX implementation - Retry Attempt 2

from docplex.mp.model import Model

def optimize_party_people():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="party_people")
    
    # Data from the problem statement
    member_ids = [1, 2, 3]
    event_ids = [101, 102, 103]
    
    # Effectiveness scores
    efficiency_scores = {
        (1, 101): 0.85,
        (2, 102): 0.95,
        (3, 103): 0.75
    }
    
    # Member availability
    is_available = {
        (1, 101): True,
        (2, 102): False,
        (3, 103): True
    }
    
    # Event capacities
    max_members_per_event = {
        101: 50,
        102: 100,
        103: 150
    }
    
    # 2. VARIABLES
    x = {(i, j): mdl.binary_var(name=f"x_{i}_{j}") for i in member_ids for j in event_ids}
    
    # 3. OBJECTIVE FUNCTION
    objective = mdl.sum(efficiency_scores.get((i, j), 0) * x[(i, j)] for i in member_ids for j in event_ids)
    mdl.maximize(objective)
    
    # 4. CONSTRAINTS
    # Event Capacity Constraints
    for j in event_ids:
        mdl.add_constraint(mdl.sum(x[(i, j)] for i in member_ids) <= max_members_per_event[j], ctname=f"capacity_{j}")
    
    # Member Availability Constraints
    for i in member_ids:
        for j in event_ids:
            if not is_available.get((i, j), False):
                mdl.add_constraint(x[(i, j)] == 0, ctname=f"availability_{i}_{j}")
    
    # 5. SOLVING & RESULTS
    solution = mdl.solve()
    
    if solution:
        print(f"Optimal value: {solution.objective_value}")
        for i in member_ids:
            for j in event_ids:
                if solution.get_value(x[(i, j)]) > 0.5:  # Check if assigned
                    print(f"Member {i} assigned to Event {j}")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")

# Run the optimization
optimize_party_people()