# Complete Optimization Problem and Solution: party_people

## 1. Problem Context and Goals

### Context  
A political organization is focused on enhancing the effectiveness of its events by strategically assigning its members to various party events. Each member has a unique effectiveness score for each event, reflecting their potential contribution to the event's success. The organization aims to assign members to events in a manner that maximizes the overall effectiveness of these events. This involves making decisions about which members to assign to which events, represented by binary decision variables indicating whether a member is assigned to an event. The operational parameters include maximizing the total effectiveness, which is the sum of the effectiveness scores of assigned members. The business configuration includes a constraint on the maximum number of members that can be assigned to a single event, ensuring that no event is overstaffed. This constraint is crucial for maintaining the quality and manageability of the events. The organization must also consider the availability of members, ensuring that assignments are only made if a member is available for a particular event. These decisions and constraints are framed in a linear optimization model, focusing on precise operational decision-making without involving nonlinear relationships.

### Goals  
The primary goal of the optimization is to maximize the total effectiveness of the party events. This is achieved by optimally assigning members to events based on their effectiveness scores. The success of this optimization is measured by the total effectiveness, which is the sum of the effectiveness scores of all assigned members. The objective is to ensure that the assignments lead to the highest possible total effectiveness, aligning with the expected coefficient sources. This goal is articulated in natural language, focusing on the linear optimization objective without using mathematical formulas or symbolic notation.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the feasibility and practicality of the assignments:

- Each event has a maximum number of members that can be assigned, which is determined by the event's capacity. This constraint ensures that no event is overstaffed, maintaining the quality and manageability of the event.
- Members can only be assigned to events if they are available. This constraint respects the availability of members, ensuring that assignments are feasible and realistic.

These constraints are described in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a new table for decision variables, modifying existing tables to better map decision variables, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE effectiveness_scores (
  member_id INTEGER,
  event_id INTEGER,
  efficiency_score FLOAT
);

CREATE TABLE member_availability (
  member_id INTEGER,
  event_id INTEGER,
  is_available BOOLEAN
);

CREATE TABLE party_events (
  event_id INTEGER,
  Member_in_charge_ID INTEGER,
  max_members_per_event INTEGER
);

CREATE TABLE member_event_assignments (
  member_id INTEGER,
  event_id INTEGER,
  assignment BOOLEAN
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Effectiveness Scores**: This table stores the effectiveness scores of members for each event. These scores are used as coefficients in the objective function to determine the total effectiveness of the assignments.
  - **Member ID**: A unique identifier for each member, used as an index for effectiveness scores.
  - **Event ID**: A unique identifier for each event, used as an index for effectiveness scores.
  - **Efficiency Score**: The effectiveness score of a member for a specific event, serving as a coefficient in the objective function.

- **Member Availability**: This table indicates the availability of members for events, serving as a constraint in the optimization model.
  - **Member ID**: A unique identifier for each member, used as an index for availability.
  - **Event ID**: A unique identifier for each event, used as an index for availability.
  - **Is Available**: A boolean indicating if a member is available for an event, used as a constraint in the optimization model.

- **Party Events**: This table stores information about party events, including the maximum number of members that can be assigned to each event.
  - **Event ID**: A unique identifier for each event, used as an index for event data.
  - **Member in Charge ID**: The ID of the member in charge of the event, used for decision variable mapping.
  - **Max Members per Event**: The maximum number of members that can be assigned to the event, serving as a constraint bound.

- **Member Event Assignments**: This table stores binary decision variables indicating member assignments to events.
  - **Member ID**: A unique identifier for each member, used as an index for decision variables.
  - **Event ID**: A unique identifier for each event, used as an index for decision variables.
  - **Assignment**: A binary variable indicating if a member is assigned to an event, serving as a decision variable in the optimization model.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical event sizes and member availability patterns in political organizations, ensuring a balance between event capacity and member effectiveness.

-- Realistic data for effectiveness_scores
INSERT INTO effectiveness_scores (member_id, event_id, efficiency_score) VALUES (1, 101, 0.85);
INSERT INTO effectiveness_scores (member_id, event_id, efficiency_score) VALUES (2, 102, 0.95);
INSERT INTO effectiveness_scores (member_id, event_id, efficiency_score) VALUES (3, 103, 0.75);

-- Realistic data for member_availability
INSERT INTO member_availability (member_id, event_id, is_available) VALUES (1, 101, True);
INSERT INTO member_availability (member_id, event_id, is_available) VALUES (2, 102, False);
INSERT INTO member_availability (member_id, event_id, is_available) VALUES (3, 103, True);

-- Realistic data for party_events
INSERT INTO party_events (event_id, Member_in_charge_ID, max_members_per_event) VALUES (101, 1, 50);
INSERT INTO party_events (event_id, Member_in_charge_ID, max_members_per_event) VALUES (102, 2, 100);
INSERT INTO party_events (event_id, Member_in_charge_ID, max_members_per_event) VALUES (103, 3, 150);

-- Realistic data for member_event_assignments
INSERT INTO member_event_assignments (member_id, event_id, assignment) VALUES (1, 101, True);
INSERT INTO member_event_assignments (member_id, event_id, assignment) VALUES (2, 102, False);
INSERT INTO member_event_assignments (member_id, event_id, assignment) VALUES (3, 103, True);
```