# Complete Optimization Problem and Solution: perpetrator

## 1. Problem Context and Goals

### Context  
A government agency is responsible for reducing the number of casualties, both killed and injured, by strategically allocating resources across various locations. Each location has a unique impact on casualty reduction, and the agency must operate within a predetermined budget. The decision-making process involves determining the amount of resources to allocate to each location, represented as a continuous variable. The primary objective is to minimize the total number of casualties, calculated as the sum of killed and injured individuals at each location, weighted by the resources allocated. The agency's operations are constrained by a total budget, which serves as a limit on the total cost of resources allocated. The cost of resources at each location is known, and the total cost is calculated by summing the product of the resource cost and the amount allocated at each location. This ensures that the budget is not exceeded. The business configuration includes a scalar parameter representing the total budget and a business logic formula that calculates the total cost of resources allocated.

### Goals  
The optimization goal is to minimize the total number of casualties. This is achieved by strategically allocating resources to different locations, with the aim of reducing the sum of killed and injured individuals. Success is measured by the reduction in total casualties, which is directly influenced by the amount of resources allocated to each location. The optimization process focuses on achieving this goal while adhering to budget constraints, ensuring that the total cost of resources does not exceed the available budget.

## 2. Constraints    

The resource allocation process is subject to several constraints that ensure the feasibility of the solution. The primary constraint is that the total cost of resources allocated across all locations must not exceed the total budget available. This is calculated by summing the product of the cost of resources at each location and the amount of resources allocated to that location. Additionally, the amount of resources allocated to each location must be non-negative, ensuring that resources are only added, not removed, from any location. These constraints are designed to align with the linear mathematical formulation of the optimization problem, ensuring that the solution is both practical and achievable within the given budgetary limits.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, modifying existing tables to fill mapping gaps, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE perpetrator (
  Killed INTEGER,
  Injured INTEGER
);

CREATE TABLE ResourceAllocation (
  location_id INTEGER,
  amount FLOAT
);

CREATE TABLE LocationCosts (
  location_id INTEGER,
  cost FLOAT
);


```

### Data Dictionary  
The data is organized into three main tables, each serving a specific business purpose and optimization role:

- **Perpetrator Table**: This table stores casualty data for each location. It includes columns for the number of people killed and injured, which serve as coefficients in the objective function to minimize total casualties.

- **Resource Allocation Table**: This table records the amount of resources allocated to each location. It includes a unique identifier for each location and the amount of resources allocated, which acts as the decision variable in the optimization model.

- **Location Costs Table**: This table contains the cost data for resources at each location. It includes a unique identifier for each location and the cost of resources, which is used in the budget constraint to ensure that the total cost does not exceed the available budget.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical resource allocation scenarios in government agencies, considering the impact of resource allocation on casualty reduction and budget constraints.

-- Realistic data for perpetrator
INSERT INTO perpetrator (Killed, Injured) VALUES (10, 50);
INSERT INTO perpetrator (Killed, Injured) VALUES (5, 30);
INSERT INTO perpetrator (Killed, Injured) VALUES (20, 100);

-- Realistic data for ResourceAllocation
INSERT INTO ResourceAllocation (location_id, amount) VALUES (1, 500);
INSERT INTO ResourceAllocation (location_id, amount) VALUES (2, 300);
INSERT INTO ResourceAllocation (location_id, amount) VALUES (3, 700);

-- Realistic data for LocationCosts
INSERT INTO LocationCosts (location_id, cost) VALUES (1, 2000);
INSERT INTO LocationCosts (location_id, cost) VALUES (2, 1500);
INSERT INTO LocationCosts (location_id, cost) VALUES (3, 2500);


```