# Complete Optimization Problem and Solution: poker_player

## 1. Problem Context and Goals

### Context  
In the context of a poker tournament, the organizer aims to distribute prize money among players in a way that maximizes overall player satisfaction. The decision revolves around how much prize money to allocate to each player, represented as a continuous variable for each player. The satisfaction of each player is influenced by their performance metrics, which are quantified through satisfaction coefficients. The objective is to maximize the total satisfaction of all players by allocating prize money in proportion to these coefficients.

The operational parameters include a total budget for prize money allocation, which serves as a constraint to ensure that the total distributed prize money does not exceed this budget. Additionally, there is a maximum limit on the prize money that can be allocated to any single player, ensuring fairness and preventing any player from receiving an excessively large portion of the budget. These parameters are critical in shaping the linear optimization model, guiding the allocation process within defined limits.

### Goals  
The primary goal of this optimization problem is to maximize the total satisfaction of players participating in the tournament. This is achieved by strategically allocating prize money based on each player's satisfaction coefficient, which reflects their performance. The success of this optimization is measured by the total satisfaction score, calculated as the sum of the product of each player's satisfaction coefficient and their allocated prize money. The aim is to achieve the highest possible total satisfaction while adhering to the budgetary and individual prize constraints.

## 2. Constraints    

The constraints in this optimization problem are designed to ensure that the prize money allocation remains within practical and fair limits. The first constraint ensures that the total prize money allocated to all players does not exceed the available budget. This is a critical resource limitation that aligns with the tournament's financial capabilities. The second constraint sets a maximum limit on the prize money that can be allocated to any single player, promoting fairness and preventing disproportionate allocations. These constraints are expressed in linear terms, directly guiding the allocation process within the defined boundaries.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, and moving scalar parameters to configuration logic. This addresses the OR expert's mapping gaps and missing requirements.

CREATE TABLE PlayerSatisfactionCoefficients (
  player_id INTEGER,
  coefficient FLOAT
);

CREATE TABLE PrizeMoneyAllocation (
  player_id INTEGER,
  prize_money FLOAT
);
```

### Data Dictionary  
The data dictionary provides a business-oriented overview of the tables and columns used in the optimization model:

- **PlayerSatisfactionCoefficients Table**: This table stores the satisfaction coefficients for each player, which are used to determine the impact of prize money on player satisfaction. Each player is uniquely identified by a player ID, and their satisfaction coefficient reflects their performance metrics.

  - **player_id**: A unique identifier for each player, linking satisfaction coefficients to individual players.
  - **coefficient**: Represents the satisfaction coefficient for each player, used in calculating the total satisfaction score.

- **PrizeMoneyAllocation Table**: This table records the prize money allocated to each player, which is the decision variable in the optimization model. The allocation is determined based on the satisfaction coefficients and the constraints of the model.

  - **player_id**: A unique identifier for each player, linking prize money allocations to individual players.
  - **prize_money**: The amount of prize money allocated to each player, serving as the decision variable in the optimization process.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical poker tournament prize distributions and player performance metrics, ensuring a balance between competitive payouts and budget constraints.

-- Realistic data for PlayerSatisfactionCoefficients
INSERT INTO PlayerSatisfactionCoefficients (player_id, coefficient) VALUES (1, 1.1);
INSERT INTO PlayerSatisfactionCoefficients (player_id, coefficient) VALUES (2, 0.9);
INSERT INTO PlayerSatisfactionCoefficients (player_id, coefficient) VALUES (3, 1.3);

-- Realistic data for PrizeMoneyAllocation
INSERT INTO PrizeMoneyAllocation (player_id, prize_money) VALUES (1, 8000);
INSERT INTO PrizeMoneyAllocation (player_id, prize_money) VALUES (2, 6000);
INSERT INTO PrizeMoneyAllocation (player_id, prize_money) VALUES (3, 10000);
```