# Complete Optimization Problem and Solution: race_track

## 1. Problem Context and Goals

### Context  
The racing organization is focused on optimizing the number of spectators attending races across various tracks. The primary decision involves determining the number of races to hold at each track, represented by the variable races[track_id] for each track_id. The objective is to maximize the total number of spectators, which is directly influenced by the seating capacity of each track. The organization must also adhere to a constraint on the total number of races that can be held across all tracks, ensuring operational feasibility and maintaining spectator engagement. This constraint is defined by a business configuration parameter, the total_races_limit, which sets the maximum allowable races across all tracks. The operational parameters and constraints are structured to align with a linear optimization framework, focusing on maximizing the product of seating capacity and the number of races, without involving any nonlinear relationships.

### Goals  
The primary goal of the optimization is to maximize the total number of spectators attending the races. This is achieved by optimizing the allocation of races across different tracks, taking into account the seating capacity of each track. The success of this optimization is measured by the total number of spectators, calculated as the sum of the product of seating capacity and the number of races held at each track. The objective is clearly defined in linear terms, focusing on maximizing the potential audience while adhering to the constraints set by the business configuration.

## 2. Constraints    

The optimization problem is subject to several key constraints that ensure the solution is feasible and aligns with business requirements:

- The total number of races held across all tracks must not exceed the total_races_limit. This constraint ensures that the number of races is distributed in a way that is operationally feasible and maintains spectator interest.
- For each track, the product of the seating capacity and the number of races must not exceed the maximum number of spectators allowed at that track. This constraint ensures that the number of spectators does not surpass the track's capacity, maintaining safety and comfort for attendees.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data requirements and updating configuration logic for scalar parameters and formulas.

CREATE TABLE track (
  Seating INTEGER,
  max_spectators INTEGER
);

CREATE TABLE TrackRaces (
  races INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and roles in the optimization process:

- **Track Table**: This table stores information about each racing track.
  - **Seating**: Represents the seating capacity of each track. It is used to calculate the potential number of spectators per race, playing a crucial role in the optimization objective.
  - **Max Spectators**: Indicates the maximum number of spectators allowed at each track. This serves as a constraint to ensure that the number of spectators does not exceed the track's capacity.

- **TrackRaces Table**: This table records the number of races to be held at each track.
  - **Races**: Represents the decision variable for the optimization, indicating the number of races scheduled at each track.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical seating capacities and spectator limits for medium-sized racing tracks, ensuring a balance between maximizing spectators and adhering to constraints.

-- Realistic data for track
INSERT INTO track (Seating, max_spectators) VALUES (5000, 4500);
INSERT INTO track (Seating, max_spectators) VALUES (10000, 9500);
INSERT INTO track (Seating, max_spectators) VALUES (15000, 14500);

-- Realistic data for TrackRaces
INSERT INTO TrackRaces (races) VALUES (3);
INSERT INTO TrackRaces (races) VALUES (5);
INSERT INTO TrackRaces (races) VALUES (7);
```