# Complete Optimization Problem and Solution: railway

## 1. Problem Context and Goals

### Context  
The railway system aims to optimize the allocation of trains to various railways to achieve cost efficiency while meeting operational requirements. The primary decision involves determining the number of trains to allocate to each railway, represented by x[i], where x[i] is an integer. The operational objective is to minimize the total operational cost, calculated as the sum of the operational costs for each train allocated to a railway. The business configuration includes a total of 30 trains available for allocation, which serves as a constraint in the optimization model. Additionally, each railway must have a minimum number of trains to ensure operational viability, which is expressed through business logic that ensures each railway meets its minimum train requirement. The relationships between these elements are linear, focusing on precise decision-making without involving complex mathematical operations like variable products or divisions. The operational parameters, such as the cost per train and railway capacities, are clearly defined and mapped to their respective roles in the optimization process.

### Goals  
The primary goal of this optimization problem is to minimize the total operational cost associated with running trains across different railways. This involves optimizing the allocation of trains to ensure that the total operational cost, which is the sum of the costs for each train on a railway, is minimized. Success in this optimization is measured by achieving the lowest possible operational cost while adhering to the constraints of train availability and railway capacity. The goal is articulated in straightforward business language, focusing on reducing costs through efficient train allocation.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the solution is feasible and meets business requirements:

- The total number of trains allocated across all railways must not exceed the total number of trains available, which is 30.
- Each railway has a specific capacity that limits the maximum number of trains that can be allocated to it. The allocation for each railway must not exceed its capacity.
- Each railway requires a minimum number of trains to operate effectively. The allocation for each railway must meet or exceed this minimum requirement.

These constraints are expressed in business terms that naturally align with linear mathematical forms, ensuring that the optimization problem remains linear and straightforward.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data and updating configuration logic for scalar parameters and formulas.

CREATE TABLE RailwayOperationalCost (
  railway_id INTEGER,
  operational_cost FLOAT
);

CREATE TABLE RailwayCapacity (
  railway_id INTEGER,
  capacity INTEGER
);

CREATE TABLE Railway (
  Railway_ID INTEGER,
  minimum_trains_required INTEGER
);
```

### Data Dictionary  
The data dictionary provides a business-oriented overview of the tables and columns used in the optimization process, highlighting their purposes and roles:

- **RailwayOperationalCost**: This table stores the cost of operating a train on each railway. The operational cost is a key factor in the objective function, as it determines the cost efficiency of train allocations.
  - **railway_id**: A unique identifier for each railway, linking operational costs to specific railways.
  - **operational_cost**: The cost associated with operating one train on the railway, serving as a coefficient in the objective function.

- **RailwayCapacity**: This table captures the maximum number of trains that can be allocated to each railway, serving as a constraint in the optimization model.
  - **railway_id**: A unique identifier for each railway, linking capacity constraints to specific railways.
  - **capacity**: The maximum number of trains that can be allocated to the railway, ensuring allocations do not exceed this limit.

- **Railway**: This table contains general information about each railway, including the minimum number of trains required for operation.
  - **Railway_ID**: A unique identifier for each railway, serving as a decision variable in the optimization model.
  - **minimum_trains_required**: The minimum number of trains needed for the railway to operate effectively, serving as a constraint in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical operational costs, capacities, and minimum requirements for railways, ensuring a balance between cost efficiency and operational feasibility.

-- Realistic data for RailwayOperationalCost
INSERT INTO RailwayOperationalCost (railway_id, operational_cost) VALUES (1, 120.0);
INSERT INTO RailwayOperationalCost (railway_id, operational_cost) VALUES (2, 180.0);
INSERT INTO RailwayOperationalCost (railway_id, operational_cost) VALUES (3, 140.0);

-- Realistic data for RailwayCapacity
INSERT INTO RailwayCapacity (railway_id, capacity) VALUES (1, 12);
INSERT INTO RailwayCapacity (railway_id, capacity) VALUES (2, 18);
INSERT INTO RailwayCapacity (railway_id, capacity) VALUES (3, 15);

-- Realistic data for Railway
INSERT INTO Railway (Railway_ID, minimum_trains_required) VALUES (1, 3);
INSERT INTO Railway (Railway_ID, minimum_trains_required) VALUES (2, 4);
INSERT INTO Railway (Railway_ID, minimum_trains_required) VALUES (3, 5);
```