# Complete Optimization Problem and Solution: restaurant_1

## 1. Problem Context and Goals

### Context  
The objective is to optimize how students allocate their visits to various restaurants to achieve the highest possible satisfaction score. Each student has a specific budget that limits their total spending on restaurant visits. The decision involves determining the number of visits each student should make to each restaurant. The satisfaction score is derived from the restaurant's rating, which is multiplied by the number of visits. The budget constraint for each student is a critical factor, ensuring that the total cost of visits does not exceed their allocated budget. The cost per visit for each student-restaurant pair is used to calculate the total spending, ensuring that the optimization remains within linear constraints. This setup allows for precise decision-making, focusing on maximizing satisfaction while adhering to budgetary limits.

### Goals  
The primary goal is to maximize the total satisfaction score for all students. This is achieved by optimizing the number of visits each student makes to each restaurant, with the satisfaction score being the product of the restaurant's rating and the number of visits. The success of this optimization is measured by the total satisfaction score, which is directly influenced by the restaurant ratings and the number of visits, ensuring a clear linear relationship in the optimization process.

## 2. Constraints    

The optimization is subject to several constraints. Firstly, the total cost incurred by a student from visiting restaurants must not exceed their budget. This ensures that each student's spending remains within their financial limits. Additionally, the number of visits a student makes to any restaurant must be a non-negative integer, reflecting the realistic scenario where visits cannot be negative or fractional. These constraints are designed to maintain a linear relationship, ensuring the optimization problem remains solvable within the defined parameters.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding tables for budget constraints and cost per visit, modifying existing tables to include necessary columns, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE Restaurant (
  ResID INTEGER,
  Rating FLOAT
);

CREATE TABLE Student_Budget (
  StuID INTEGER,
  Budget INTEGER
);

CREATE TABLE Cost_Per_Visit (
  StuID INTEGER,
  ResID INTEGER,
  Cost FLOAT
);

CREATE TABLE Visits_Restaurant (
  StuID INTEGER,
  ResID INTEGER,
  Visits INTEGER
);
```

### Data Dictionary  
- **Restaurant Table**: This table holds information about each restaurant, including a unique identifier and a rating that reflects the satisfaction score a student receives from visiting the restaurant. The rating serves as a coefficient in the optimization objective, influencing the total satisfaction score.

- **Student_Budget Table**: This table contains the budget constraints for each student, identified by a unique student ID. The budget represents the maximum amount a student can spend on restaurant visits, serving as a constraint bound in the optimization model.

- **Cost_Per_Visit Table**: This table records the cost associated with each visit for a student to a specific restaurant. It includes identifiers for both the student and the restaurant, and the cost per visit is used in calculating the total spending, ensuring it aligns with the budget constraints.

- **Visits_Restaurant Table**: This table tracks the number of visits each student makes to each restaurant. It includes identifiers for both the student and the restaurant, and the number of visits is the decision variable in the optimization model, directly affecting the total satisfaction score.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical student budgets and restaurant costs, ensuring a variety of scenarios for optimization. Ratings were chosen to reflect a range of restaurant quality.

-- Realistic data for Restaurant
INSERT INTO Restaurant (ResID, Rating) VALUES (1, 4.5);
INSERT INTO Restaurant (ResID, Rating) VALUES (2, 3.8);
INSERT INTO Restaurant (ResID, Rating) VALUES (3, 5.0);

-- Realistic data for Student_Budget
INSERT INTO Student_Budget (StuID, Budget) VALUES (101, 120);
INSERT INTO Student_Budget (StuID, Budget) VALUES (102, 180);
INSERT INTO Student_Budget (StuID, Budget) VALUES (103, 150);

-- Realistic data for Cost_Per_Visit
INSERT INTO Cost_Per_Visit (StuID, ResID, Cost) VALUES (101, 1, 12.0);
INSERT INTO Cost_Per_Visit (StuID, ResID, Cost) VALUES (102, 2, 15.0);
INSERT INTO Cost_Per_Visit (StuID, ResID, Cost) VALUES (103, 3, 20.0);

-- Realistic data for Visits_Restaurant
INSERT INTO Visits_Restaurant (StuID, ResID, Visits) VALUES (101, 1, 3);
INSERT INTO Visits_Restaurant (StuID, ResID, Visits) VALUES (102, 2, 4);
INSERT INTO Visits_Restaurant (StuID, ResID, Visits) VALUES (103, 3, 2);
```