# Complete Optimization Problem and Solution: restaurants

## 1. Problem Context and Goals

### Context  
A restaurant chain is aiming to strategically allocate its marketing budget across various cities to enhance the overall ratings of its restaurants. The decision involves determining the amount of budget to allocate to each city, represented by the decision variable `BudgetAllocations.allocation[city_id]`, which is continuous. The primary objective is to maximize the expected improvement in restaurant ratings, which is directly influenced by the budget allocated to each city. Each city has a specific potential for rating improvement per unit of budget spent, captured by `CityRatingImprovementCoefficients.coefficient[city_id]`. The total marketing budget available for allocation is a fixed amount, serving as a constraint in the optimization model. This budget constraint ensures that the sum of all allocations does not exceed the total budget. The business configuration includes this total budget as a scalar parameter, ensuring that the allocation decisions are made within the available financial resources. The focus is on making precise operational decisions that align with linear optimization principles, avoiding any nonlinear relationships such as variable products or divisions.

### Goals  
The optimization goal is to maximize the overall improvement in restaurant ratings across all cities. This is achieved by optimizing the sum of the expected rating improvements, which is calculated by multiplying the potential rating improvement per unit of budget (`CityRatingImprovementCoefficients.coefficient[city_id]`) by the budget allocated to each city (`BudgetAllocations.allocation[city_id]`). Success is measured by the extent to which the total expected rating improvement is maximized, aligning with the linear optimization objective. The goal is clearly defined in natural language, focusing on the linear relationship between budget allocation and rating improvement.

## 2. Constraints    

The optimization problem is subject to specific constraints that ensure the solution is feasible within the business context. The primary constraint is that the total budget allocated across all cities must not exceed the total marketing budget available. This is expressed as the sum of all budget allocations being less than or equal to the total budget. Additionally, each city's budget allocation must be non-negative, ensuring that no city receives a negative budget. These constraints are described in business terms, naturally leading to linear mathematical forms without involving any nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for decision variables and objective coefficients, and updating business configuration logic for constraint bounds.

CREATE TABLE CityRatingImprovementCoefficients (
  city_id INTEGER,
  coefficient FLOAT
);

CREATE TABLE BudgetAllocations (
  city_id INTEGER,
  allocation FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and roles in the optimization process:

- **CityRatingImprovementCoefficients**: This table stores the expected rating improvement per unit of budget spent in each city. It plays a crucial role in the optimization as it provides the coefficients for the objective function.
  - **city_id**: A unique identifier for each city, used to index city-specific coefficients.
  - **coefficient**: Represents the expected rating improvement per unit of budget, serving as a coefficient in the objective function.

- **BudgetAllocations**: This table records the amount of budget allocated to each city, representing the decision variables in the optimization model.
  - **city_id**: A unique identifier for each city, used to index budget allocations.
  - **allocation**: The amount of budget allocated to the city, serving as a decision variable in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical marketing budget allocations and expected rating improvements in the restaurant industry, ensuring a balance between potential improvements and budget constraints.

-- Realistic data for CityRatingImprovementCoefficients
INSERT INTO CityRatingImprovementCoefficients (city_id, coefficient) VALUES (1, 0.15);
INSERT INTO CityRatingImprovementCoefficients (city_id, coefficient) VALUES (2, 0.25);
INSERT INTO CityRatingImprovementCoefficients (city_id, coefficient) VALUES (3, 0.1);

-- Realistic data for BudgetAllocations
INSERT INTO BudgetAllocations (city_id, allocation) VALUES (1, 30000);
INSERT INTO BudgetAllocations (city_id, allocation) VALUES (2, 50000);
INSERT INTO BudgetAllocations (city_id, allocation) VALUES (3, 20000);
```