# Complete Optimization Problem and Solution: singer

## 1. Problem Context and Goals

### Context  
A music production company is focused on enhancing its total sales by strategically promoting a selection of songs. The decision to promote each song is represented by a binary choice: either a song is promoted or it is not. The primary objective is to maximize the overall sales increase, which is directly linked to the potential sales boost each song could achieve if promoted. The company operates under specific constraints, including a fixed budget allocated for promotional activities and a cap on the number of songs that can be promoted. These constraints ensure that the promotion strategy remains financially viable and strategically focused. The budget and the maximum number of songs to promote are critical parameters that guide the decision-making process, ensuring that the company optimizes its promotional efforts within these limits.

### Goals  
The overarching goal of the optimization process is to maximize the total sales of the songs. This is achieved by selecting the optimal set of songs to promote, thereby maximizing the potential sales increase. The success of this strategy is measured by the total sales increase, which is calculated as the sum of the potential sales increases for all promoted songs. The objective is clearly defined in linear terms, focusing on maximizing the sum of potential sales increases, which aligns with the company's strategic aim to enhance revenue through targeted promotions.

## 2. Constraints    

The company faces two primary constraints in its promotional strategy. First, the total cost of promoting the selected songs must not exceed the allocated budget. This ensures that the promotional activities remain within the financial limits set by the company. Second, there is a restriction on the number of songs that can be promoted, which encourages a strategic selection process to maximize the impact of the promotions. These constraints are expressed in linear terms, focusing on the sum of promotion costs and the count of promoted songs, respectively, ensuring that the optimization problem remains linear and manageable.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data, modifying existing tables to fill mapping gaps, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE Song (
  SongID INTEGER,
  PotentialSalesIncrease FLOAT
);

CREATE TABLE PromotionCost (
  SongID INTEGER,
  Cost FLOAT,
  Promote BOOLEAN
);
```

### Data Dictionary  
The data is organized into two main tables, each serving a distinct purpose in the optimization process. The "Song" table contains information about each song, specifically focusing on the potential sales increase that could be achieved if the song is promoted. This data is crucial for determining the objective coefficients in the optimization model. The "PromotionCost" table records the cost associated with promoting each song and indicates whether a song is currently promoted. This information is vital for defining the constraints related to promotion costs and decision variables. Each table and column is designed to support the linear optimization formulation, ensuring that the data aligns with the company's strategic goals.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical music promotion costs and potential sales increases observed in the industry, ensuring that the budget and promotion limits are realistic and allow for meaningful decision-making.

-- Realistic data for Song
INSERT INTO Song (SongID, PotentialSalesIncrease) VALUES (1, 1200.0);
INSERT INTO Song (SongID, PotentialSalesIncrease) VALUES (2, 1800.0);
INSERT INTO Song (SongID, PotentialSalesIncrease) VALUES (3, 2500.0);

-- Realistic data for PromotionCost
INSERT INTO PromotionCost (SongID, Cost, Promote) VALUES (1, 600.0, False);
INSERT INTO PromotionCost (SongID, Cost, Promote) VALUES (2, 900.0, False);
INSERT INTO PromotionCost (SongID, Cost, Promote) VALUES (3, 1200.0, False);
```