# Complete DOCPLEX implementation - Retry Attempt 4

from docplex.mp.model import Model

def soccer_team_selection():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="soccer_team_selection")

    # Data from the problem statement
    players = [
        {"pID": 1, "pPos": "Goalkeeper", "cName": "College A", "yCard": 0},
        {"pID": 2, "pPos": "Defender", "cName": "College B", "yCard": 1},
        {"pID": 3, "pPos": "Midfielder", "cName": "College C", "yCard": 2},
        {"pID": 4, "pPos": "Forward", "cName": "College A", "yCard": 1},
        {"pID": 5, "pPos": "Defender", "cName": "College B", "yCard": 0}
    ]

    position_requirements = {
        "Goalkeeper": 1,
        "Defender": 4,
        "Midfielder": 4,
        "Forward": 2
    }

    college_limits = {
        "College A": 3,
        "College B": 3,
        "College C": 3
    }

    # 2. VARIABLES
    x = {player["pID"]: mdl.binary_var(name=f"x_{player['pID']}") for player in players}

    # 3. OBJECTIVE FUNCTION
    objective = mdl.sum(player["yCard"] * x[player["pID"]] for player in players)
    mdl.minimize(objective)

    # 4. CONSTRAINTS

    # Position requirements
    for position, required_players in position_requirements.items():
        mdl.add_constraint(
            mdl.sum(x[player["pID"]] for player in players if player["pPos"] == position) == required_players,
            ctname=f"position_{position}"
        )

    # College diversity
    for college, max_players in college_limits.items():
        mdl.add_constraint(
            mdl.sum(x[player["pID"]] for player in players if player["cName"] == college) <= max_players,
            ctname=f"college_{college}"
        )

    # 5. SOLVING & RESULTS
    solution = mdl.solve()

    if solution:
        print(f"Optimal value: {solution.objective_value}")
        for player in players:
            if solution.get_value(x[player["pID"]]) > 0.5:
                print(f"Player {player['pID']} selected")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")

    return mdl

# Execute the function
soccer_team_selection()