# Complete GUROBIPY implementation - Retry Attempt 4

import gurobipy as gp
from gurobipy import GRB

def soccer_team_selection():
    # 1. MODEL & DATA SETUP
    model = gp.Model("soccer_2")

    # Data from the problem statement
    players = [
        {"pID": 1, "pPos": "Goalkeeper", "cName": "College A", "yCard": 0},
        {"pID": 2, "pPos": "Defender", "cName": "College B", "yCard": 1},
        {"pID": 3, "pPos": "Midfielder", "cName": "College C", "yCard": 2},
        {"pID": 4, "pPos": "Forward", "cName": "College A", "yCard": 1},
        {"pID": 5, "pPos": "Defender", "cName": "College B", "yCard": 0}
    ]

    position_requirements = {
        "Goalkeeper": 1,
        "Defender": 4,
        "Midfielder": 4,
        "Forward": 2
    }

    college_limits = {
        "College A": 3,
        "College B": 3,
        "College C": 3
    }

    # 2. VARIABLES
    x = {player["pID"]: model.addVar(vtype=GRB.BINARY, name=f"x_{player['pID']}")
         for player in players}

    # 3. OBJECTIVE FUNCTION
    model.setObjective(gp.quicksum(player["yCard"] * x[player["pID"]] for player in players), GRB.MINIMIZE)

    # 4. CONSTRAINTS

    # Position requirements
    for position, required_players in position_requirements.items():
        model.addConstr(
            gp.quicksum(x[player["pID"]] for player in players if player["pPos"] == position) == required_players,
            name=f"position_{position}"
        )

    # College diversity
    for college, max_players in college_limits.items():
        model.addConstr(
            gp.quicksum(x[player["pID"]] for player in players if player["cName"] == college) <= max_players,
            name=f"college_{college}"
        )

    # 5. SOLVING & RESULTS
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print(f"Optimal value: {model.objVal}")
        for player in players:
            if x[player["pID"]].x > 1e-6:
                print(f"Player {player['pID']} selected")
    elif model.status == GRB.INFEASIBLE:
        print("Problem is infeasible")
    elif model.status == GRB.UNBOUNDED:
        print("Problem is unbounded")

    return model

# Run the optimization
soccer_team_selection()