# Complete Optimization Problem and Solution: sports_competition

## 1. Problem Context and Goals

### Context  
In a competitive sports league, the objective is to strategically allocate players to various clubs to maximize the overall points scored by all clubs. Each player has a specific number of points they can contribute, and they are allowed to apply to a limited number of clubs. Clubs, on the other hand, have a maximum capacity for the number of players they can accommodate. The decision-making process involves determining whether a player is assigned to a club, represented by a binary decision variable. The goal is to maximize the total points scored by all clubs, which is achieved by summing the points of players assigned to clubs. The business configuration includes a parameter that limits the number of applications a player can make, ensuring that the optimization respects these constraints. This setup naturally leads to a linear optimization problem, where the focus is on maximizing the total points while adhering to the constraints of player applications and club capacities.

### Goals  
The primary goal of this optimization problem is to maximize the total points scored by all clubs in the league. This is achieved by strategically assigning players to clubs in a way that maximizes the sum of the points contributed by each player assigned to a club. The success of this optimization is measured by the total points accumulated, which directly correlates with the points each player can contribute when assigned to a club. The objective is clearly defined in linear terms, focusing on maximizing the total points without involving any complex mathematical operations beyond addition.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the feasibility and practicality of the player assignments:

- Each player can apply to a limited number of clubs, which is defined by the maximum number of applications they can make. This constraint ensures that the number of clubs a player is assigned to does not exceed their application limit.
- Each club has a capacity limit, which dictates the maximum number of players it can accommodate. This constraint ensures that the total number of players assigned to a club does not exceed its capacity.
- The assignment of players to clubs is represented by a binary decision variable, indicating whether a player is assigned to a club or not. This constraint ensures that each assignment decision is binary, reflecting the reality of player assignments.

These constraints are expressed in linear terms, aligning with the business requirements and ensuring that the optimization problem remains linear.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for club capacities and player applications, modifying existing tables to include missing mappings, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE Player (
  PlayerID INTEGER,
  Points INTEGER,
  MaxApps INTEGER
);

CREATE TABLE ClubCapacity (
  ClubID INTEGER,
  Capacity INTEGER
);

CREATE TABLE PlayerClubAssignment (
  PlayerID INTEGER,
  ClubID INTEGER,
  Assigned BOOLEAN
);

CREATE TABLE PlayerApplications (
  id INTEGER PRIMARY KEY,
  value NUMBER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in the optimization problem, highlighting their business purposes and roles in the optimization process:

- **Player Table**: This table stores information about each player, including their unique identifier, the points they can contribute, and the maximum number of applications they can make. The points are used as coefficients in the optimization objective, while the application limit serves as a constraint.

- **ClubCapacity Table**: This table contains information about each club's capacity, specifying the maximum number of players each club can accommodate. This capacity serves as a constraint in the optimization problem.

- **PlayerClubAssignment Table**: This table tracks the assignment of players to clubs, using a binary variable to indicate whether a player is assigned to a club. This assignment is the primary decision variable in the optimization problem.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical sports league structures, ensuring a balance between player applications and club capacities to allow for meaningful optimization.

-- Realistic data for Player
INSERT INTO Player (PlayerID, Points, MaxApps) VALUES (1, 15, 3);
INSERT INTO Player (PlayerID, Points, MaxApps) VALUES (2, 25, 4);
INSERT INTO Player (PlayerID, Points, MaxApps) VALUES (3, 10, 2);

-- Realistic data for ClubCapacity
INSERT INTO ClubCapacity (ClubID, Capacity) VALUES (1, 5);
INSERT INTO ClubCapacity (ClubID, Capacity) VALUES (2, 10);
INSERT INTO ClubCapacity (ClubID, Capacity) VALUES (3, 8);

-- Realistic data for PlayerClubAssignment
INSERT INTO PlayerClubAssignment (PlayerID, ClubID, Assigned) VALUES (1, 1, False);
INSERT INTO PlayerClubAssignment (PlayerID, ClubID, Assigned) VALUES (2, 2, True);
INSERT INTO PlayerClubAssignment (PlayerID, ClubID, Assigned) VALUES (3, 3, False);
```