# Complete Optimization Problem and Solution: store_product

## 1. Problem Context and Goals

### Context  
A retail chain is focused on optimizing the distribution of its products across various stores to maximize sales potential. The decision-making process involves determining the number of units of each product to assign to each store. This decision is represented by the integer variable: units_assigned[store_id, product_id], which indicates the number of units of a product assigned to a store. The primary objective is to maximize total sales by efficiently allocating products based on their potential sales value and the store's capacity to accommodate them. Each store has a defined maximum capacity, which serves as a constraint in the optimization model. The business configuration includes this maximum capacity, ensuring that the allocation respects the store's limitations. The operational parameters are aligned with a linear objective, focusing on maximizing the total sales value derived from the product distribution. The data reflects current operational information, emphasizing precise decision-making that leads to linear formulations. Resource limitations are considered, ensuring that the constraints are linear and do not involve nonlinear relationships such as variable products or divisions. The business configuration parameters are referenced appropriately to maintain consistency and authenticity in the optimization process.

### Goals  
The primary goal of the optimization is to maximize the total sales potential of the retail chain. This is achieved by distributing products to stores in a manner that maximizes the total sales value. The metric to optimize is the total sales, calculated as the sum of the sales value of each product multiplied by the number of units assigned to each store. Success is measured by the alignment of the optimization process with the expected coefficient sources, ensuring that the sales potential is maximized through a linear optimization goal. The description of this goal is presented in natural language, avoiding mathematical formulas or symbolic notation, to clearly convey the linear nature of the optimization objective.

## 2. Constraints    

The optimization process is subject to several constraints that ensure the feasibility and practicality of the product distribution:

- The total number of units assigned to each product across all stores must not exceed the available units for that product. This constraint ensures that the distribution respects the product's availability.
- Each store has a maximum capacity, and the total number of units assigned to all products in a store must not exceed this capacity. This constraint ensures that the store's limitations are respected.
- The number of units assigned to each product in each store must be non-negative, ensuring that the distribution is realistic and feasible.

These constraints are described in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a new table for decision variables, modifying existing tables to improve mapping adequacy, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE ProductSalesValue (
  product_id INTEGER,
  sales_value FLOAT
);

CREATE TABLE ProductAvailability (
  product_id INTEGER,
  availability INTEGER
);

CREATE TABLE Store (
  store_id INTEGER,
  store_capacity INTEGER
);

CREATE TABLE ProductDistribution (
  store_id INTEGER,
  product_id INTEGER,
  units_assigned INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **ProductSalesValue**: This table stores the potential sales values for each product. The sales value serves as a coefficient in the objective function, linking the sales potential to specific products.
  - **product_id**: A unique identifier for each product, linking sales value to specific products.
  - **sales_value**: The potential sales value of the product, used as a coefficient in the objective function.

- **ProductAvailability**: This table contains data on the availability of each product, serving as a constraint bound in the optimization model.
  - **product_id**: A unique identifier for each product, linking availability to specific products.
  - **availability**: The number of units available for distribution, used as a constraint bound.

- **Store**: This table provides information about each store, including its capacity, which serves as a constraint bound in the optimization model.
  - **store_id**: A unique identifier for each store, linking store data to optimization variables.
  - **store_capacity**: The maximum number of products a store can accommodate, used as a constraint bound.

- **ProductDistribution**: This table records the distribution of products to stores, representing the decision variables in the optimization model.
  - **store_id**: A unique identifier for each store, linking distribution data to specific stores.
  - **product_id**: A unique identifier for each product, linking distribution data to specific products.
  - **units_assigned**: The number of units of the product assigned to the store, serving as a decision variable.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical retail scenarios, considering product demand, store capacity, and sales potential. The approach ensures that the data reflects realistic business operations and constraints.

-- Realistic data for ProductSalesValue
INSERT INTO ProductSalesValue (product_id, sales_value) VALUES (1, 12.5);
INSERT INTO ProductSalesValue (product_id, sales_value) VALUES (2, 25.0);
INSERT INTO ProductSalesValue (product_id, sales_value) VALUES (3, 18.0);

-- Realistic data for ProductAvailability
INSERT INTO ProductAvailability (product_id, availability) VALUES (1, 60);
INSERT INTO ProductAvailability (product_id, availability) VALUES (2, 80);
INSERT INTO ProductAvailability (product_id, availability) VALUES (3, 70);

-- Realistic data for Store
INSERT INTO Store (store_id, store_capacity) VALUES (1, 120);
INSERT INTO Store (store_id, store_capacity) VALUES (2, 180);
INSERT INTO Store (store_id, store_capacity) VALUES (3, 150);

-- Realistic data for ProductDistribution
INSERT INTO ProductDistribution (store_id, product_id, units_assigned) VALUES (1, 1, 20);
INSERT INTO ProductDistribution (store_id, product_id, units_assigned) VALUES (2, 2, 40);
INSERT INTO ProductDistribution (store_id, product_id, units_assigned) VALUES (3, 3, 30);
```