# Complete Optimization Problem and Solution: voter_1

## 1. Problem Context and Goals

### Context  
In a competitive voting scenario, contestants receive votes from various states. The primary business decision involves determining the number of votes each contestant receives from each state. The operational objective is to maximize the total number of votes received by all contestants. This is achieved by ensuring that each contestant receives a minimum number of votes from each state, while also adhering to a cap on the total number of votes a contestant can receive. The business configuration includes two critical parameters: the maximum number of votes a contestant can receive, and the minimum number of votes each contestant must receive from each state. These parameters are essential for maintaining a fair and competitive environment, ensuring that contestants have a baseline level of support across all states.

### Goals  
The optimization goal is to maximize the total number of votes received by all contestants. The metric for optimization is the sum of votes received by each contestant from all states. Success is measured by achieving the highest possible total vote count while respecting the constraints set by the business configuration parameters. The focus is on maximizing the total votes, ensuring that the optimization process aligns with the linear objective of increasing the overall vote tally.

## 2. Constraints    

The constraints are designed to ensure fair competition and adherence to business rules. Each contestant's total votes from all states must not exceed the maximum number of votes allowed per contestant. Additionally, each contestant must receive at least a minimum number of votes from each state. These constraints are critical for maintaining a balanced distribution of votes and ensuring that each contestant has a fair chance of success. The constraints are linear in nature, focusing on the sum of votes and ensuring minimum thresholds are met.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization requirements and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE CONTESTANT_VOTES (
  contestant_id INTEGER,
  state_id INTEGER,
  votes INTEGER
);
```

### Data Dictionary  
The "CONTESTANT_VOTES" table serves a crucial role in the voting competition. It records the number of votes each contestant receives from each state. The table includes the following columns:

- **Contestant ID**: This is a unique identifier for each contestant, allowing the system to track votes on an individual basis.
- **State ID**: This identifier represents each state, ensuring that votes are accurately attributed to the correct geographical location.
- **Votes**: This column captures the number of votes a contestant receives from a specific state, serving as the decision variable in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical voting patterns and constraints to ensure a balanced distribution of votes across contestants and states.

-- Realistic data for CONTESTANT_VOTES
INSERT INTO CONTESTANT_VOTES (contestant_id, state_id, votes) VALUES (1, 1, 120);
INSERT INTO CONTESTANT_VOTES (contestant_id, state_id, votes) VALUES (1, 2, 80);
INSERT INTO CONTESTANT_VOTES (contestant_id, state_id, votes) VALUES (1, 3, 100);
INSERT INTO CONTESTANT_VOTES (contestant_id, state_id, votes) VALUES (2, 1, 90);
INSERT INTO CONTESTANT_VOTES (contestant_id, state_id, votes) VALUES (2, 2, 110);
INSERT INTO CONTESTANT_VOTES (contestant_id, state_id, votes) VALUES (2, 3, 95);
INSERT INTO CONTESTANT_VOTES (contestant_id, state_id, votes) VALUES (3, 1, 85);
INSERT INTO CONTESTANT_VOTES (contestant_id, state_id, votes) VALUES (3, 2, 105);
INSERT INTO CONTESTANT_VOTES (contestant_id, state_id, votes) VALUES (3, 3, 115);
```