# Complete Optimization Problem and Solution: wedding

## 1. Problem Context and Goals

### Context  
The objective is to optimize the allocation of weddings to churches in a manner that maximizes the total number of weddings held. This involves making decisions about which church will host each wedding, with the decision variables being whether a wedding is allocated to a specific church with a particular male and female participant. The operational parameters are aligned with the goal of maximizing the total number of weddings, which is achieved by summing the allocations across all churches and participants.

Each church has a maximum number of weddings it can host per year, which serves as a constraint in the optimization model. Additionally, business logic ensures that each participant, whether male or female, is involved in at most one wedding. This is expressed in natural language as a constraint that limits each participant to a single wedding engagement.

The data presented reflects current operational information, focusing on precise decision-making that leads to a linear formulation. Resource limitations, such as church capacity and participant availability, are considered as linear constraints. The business configuration includes both scalar parameters, like the maximum number of weddings a church can host, and business logic formulas that ensure unique participation.

### Goals  
The primary goal of this optimization problem is to maximize the total number of weddings held across all available churches. The metric to optimize is the total number of weddings, which is calculated by summing the allocations of weddings to churches, ensuring that each wedding involves one male and one female participant. Success is measured by the ability to maximize this total while adhering to the constraints of church capacity and unique participant involvement. The optimization goal is described in natural language, focusing on maximizing the number of weddings without using mathematical formulas or symbolic notation.

## 2. Constraints    

The constraints for this optimization problem are designed to ensure that the allocation of weddings adheres to the operational limitations of the churches and the unique participation of individuals:

- Each church can host a limited number of weddings per year, which is determined by its capacity. This constraint ensures that the total number of weddings allocated to a church does not exceed its capacity.
- Each male participant can be involved in at most one wedding. This constraint ensures that no male participant is allocated to more than one wedding.
- Each female participant can be involved in at most one wedding. This constraint ensures that no female participant is allocated to more than one wedding.

These constraints are described in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for church capacities and participant constraints, modifying existing tables to improve mapping adequacy, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE wedding (
  Church_ID INTEGER,
  Male_ID INTEGER,
  Female_ID INTEGER,
  total_weddings INTEGER
);

CREATE TABLE ChurchCapacity (
  church_id INTEGER,
  capacity INTEGER
);

CREATE TABLE ParticipantConstraints (
  participant_id INTEGER,
  constraint_type STRING
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Wedding Table**: This table stores information about weddings held at churches. It plays a crucial role in the optimization as it contains the decision variables for allocating weddings. The columns include:
  - **Church_ID**: Identifies the church where the wedding is held. It is used to allocate weddings to specific churches.
  - **Male_ID**: Identifies the male participant in the wedding. It ensures unique male participation.
  - **Female_ID**: Identifies the female participant in the wedding. It ensures unique female participation.
  - **Total_Weddings**: Represents the total number of weddings held, serving as the objective coefficient for maximizing weddings.

- **ChurchCapacity Table**: This table stores the capacity limits for each church, which are used as constraint bounds in the optimization model. The columns include:
  - **Church_ID**: Identifies the church and links to the church capacity constraints.
  - **Capacity**: Indicates the maximum number of weddings a church can host, serving as a constraint bound.

- **ParticipantConstraints Table**: This table ensures the unique participation of individuals in weddings. The columns include:
  - **Participant_ID**: Identifies the participant, ensuring unique participation.
  - **Constraint_Type**: Defines the type of participation constraint, such as male or female.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical church capacities and participant availability to ensure a realistic and solvable optimization problem.

-- Realistic data for wedding
INSERT INTO wedding (Church_ID, Male_ID, Female_ID, total_weddings) VALUES (1, 101, 201, 10);
INSERT INTO wedding (Church_ID, Male_ID, Female_ID, total_weddings) VALUES (2, 102, 202, 15);
INSERT INTO wedding (Church_ID, Male_ID, Female_ID, total_weddings) VALUES (3, 103, 203, 20);

-- Realistic data for ChurchCapacity
INSERT INTO ChurchCapacity (church_id, capacity) VALUES (1, 100);
INSERT INTO ChurchCapacity (church_id, capacity) VALUES (2, 150);
INSERT INTO ChurchCapacity (church_id, capacity) VALUES (3, 200);

-- Realistic data for ParticipantConstraints
INSERT INTO ParticipantConstraints (participant_id, constraint_type) VALUES (101, 'male');
INSERT INTO ParticipantConstraints (participant_id, constraint_type) VALUES (102, 'male');
INSERT INTO ParticipantConstraints (participant_id, constraint_type) VALUES (103, 'male');
INSERT INTO ParticipantConstraints (participant_id, constraint_type) VALUES (201, 'female');
INSERT INTO ParticipantConstraints (participant_id, constraint_type) VALUES (202, 'female');
INSERT INTO ParticipantConstraints (participant_id, constraint_type) VALUES (203, 'female');
```