# Complete Optimization Problem and Solution: wine_1

## 1. Problem Context and Goals

### Context  
The winery is focused on optimizing its production strategy to maximize revenue from wine sales. The primary decision involves determining the number of cases to produce for each type of wine. This decision is guided by the winery's total production capacity and the market demand for each wine. The goal is to ensure that production decisions align with these constraints while maximizing revenue. The winery operates under a total production capacity, which serves as a critical constraint, ensuring that production does not exceed operational capabilities. The business configuration includes this total production capacity as a scalar parameter, reflecting the realistic production limits of a small to medium-sized winery. The winery's operational parameters are structured to align with a linear objective, focusing on maximizing total revenue by considering the price per case of each wine and the number of cases produced.

### Goals  
The primary goal of the winery is to maximize its total revenue from wine sales. This involves optimizing the number of cases produced for each wine type, with the objective of maximizing the sum of the revenue generated from each wine. The success of this optimization is measured by the total revenue, which is calculated by multiplying the price per case by the number of cases produced for each wine. The winery aims to achieve this goal by adhering to linear optimization principles, ensuring that the production strategy is both efficient and aligned with market demands.

## 2. Constraints    

The winery's production strategy is subject to several constraints that ensure operational feasibility and market alignment. The first constraint is the total production capacity, which limits the sum of all cases produced to not exceed the winery's operational capacity. This ensures that the production remains within the realistic limits of the winery's capabilities. Additionally, each wine's production is constrained by its market demand, ensuring that the number of cases produced does not exceed what the market can absorb. These constraints are designed to naturally lead to linear mathematical forms, focusing on maintaining a balance between production capacity and market demand without involving complex variable interactions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding tables for missing data requirements and updating existing tables to address mapping gaps. Configuration logic updated for scalar parameters and formulas.

CREATE TABLE wine (
  Price FLOAT,
  Cases INTEGER
);

CREATE TABLE market_demand (
  demand INTEGER
);


```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the business purposes and optimization roles of the tables and columns involved in the winery's production strategy. The "wine" table stores information about different wines, with columns for the price per case and the number of cases to produce. The price per case serves as an objective coefficient in the revenue maximization goal, while the number of cases represents the decision variable in the optimization process. The "market_demand" table captures the market demand for each wine, serving as a constraint bound in the optimization model. This structure ensures that all data elements are aligned with the linear mathematical formulation of the optimization problem.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical market prices and demands for wine, ensuring that production capacity constraints are realistic and allow for a meaningful optimization problem.

-- Realistic data for wine
INSERT INTO wine (Price, Cases) VALUES (12.0, 150);
INSERT INTO wine (Price, Cases) VALUES (18.0, 250);
INSERT INTO wine (Price, Cases) VALUES (22.0, 100);

-- Realistic data for market_demand
INSERT INTO market_demand (demand) VALUES (500);
INSERT INTO market_demand (demand) VALUES (800);
INSERT INTO market_demand (demand) VALUES (300);


```