# Complete Optimization Problem and Solution: world_1

## 1. Problem Context and Goals

### Context  
A global logistics company is focused on optimizing the distribution of goods from a central warehouse to various cities. The primary decision involves determining the quantity of goods to be shipped to each city, where this quantity is a continuous variable. The company aims to minimize the total transportation cost, which is calculated by multiplying the transportation cost per unit for each city by the quantity of goods shipped to that city. The total number of goods available for distribution acts as a constraint, ensuring that the sum of goods shipped does not exceed this total. Additionally, the company must consider each city's demand and the maximum capacity that can be shipped to each city. These operational parameters are crucial for maintaining a linear relationship in the optimization model, avoiding any nonlinear scenarios such as variable products or divisions. The business configuration includes scalar parameters like the total available goods and business logic formulas that calculate the total transportation cost, ensuring consistency and flexibility in parameter tuning.

### Goals  
The primary goal of the optimization is to minimize the total transportation cost associated with distributing goods from the central warehouse to various cities. This involves optimizing the metric of total transportation cost, which is the sum of the transportation cost per unit for each city multiplied by the quantity of goods shipped to that city. Success in this optimization is measured by achieving the lowest possible transportation cost while adhering to the constraints of total available goods, city demands, and city capacities. The goal is articulated in natural language to maintain a clear focus on linear optimization without resorting to mathematical formulas or symbolic notation.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the solution is feasible and aligns with business requirements. These constraints are:

- The total quantity of goods shipped to all cities must not exceed the total number of goods available for distribution. This ensures that the sum of quantities shipped respects the overall supply limit.
- The quantity of goods shipped to each city must not exceed the maximum capacity that can be handled by that city. This constraint ensures that city-specific logistical limits are not breached.
- The quantity of goods shipped to each city must meet or exceed the demand of that city. This ensures that each city's demand is satisfied, maintaining service levels and customer satisfaction.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added a new table for decision variables and updated business configuration logic for scalar parameters and formulas based on OR expert mapping analysis.

CREATE TABLE TransportationCosts (
  city_id INTEGER,
  cost_per_unit FLOAT
);

CREATE TABLE CityCapacities (
  city_id INTEGER,
  max_capacity INTEGER
);

CREATE TABLE City (
  city_id INTEGER,
  city_demand INTEGER
);

CREATE TABLE QuantityShipped (
  city_id INTEGER,
  quantity FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **TransportationCosts**: This table stores the cost of transporting one unit of goods to each city. It plays a critical role in the objective function as it provides the coefficients needed to calculate the total transportation cost.
  - **city_id**: A unique identifier for each city, linking transportation costs to specific cities.
  - **cost_per_unit**: Represents the cost to transport one unit of goods to the city, serving as a coefficient in the objective function.

- **CityCapacities**: This table contains the maximum capacity of goods that can be shipped to each city, serving as a constraint bound in the optimization model.
  - **city_id**: A unique identifier for each city, linking capacities to specific cities.
  - **max_capacity**: The maximum number of goods that can be shipped to the city, used as a constraint in the optimization.

- **City**: This table holds information about each city, including the demand for goods, which acts as a constraint bound in the optimization.
  - **city_id**: A unique identifier for each city, serving as the primary key for city data.
  - **city_demand**: The demand for goods in the city, used as a constraint in the optimization.

- **QuantityShipped**: This table records the quantity of goods shipped to each city, representing the decision variables in the optimization model.
  - **city_id**: A unique identifier for each city, linking quantities to specific cities.
  - **quantity**: The number of goods shipped to the city, serving as a decision variable in the optimization.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical logistics scenarios, ensuring that transportation costs, city demands, and capacities are realistic and align with the total available goods.

-- Realistic data for TransportationCosts
INSERT INTO TransportationCosts (city_id, cost_per_unit) VALUES (1, 5.0);
INSERT INTO TransportationCosts (city_id, cost_per_unit) VALUES (2, 10.0);
INSERT INTO TransportationCosts (city_id, cost_per_unit) VALUES (3, 15.0);

-- Realistic data for CityCapacities
INSERT INTO CityCapacities (city_id, max_capacity) VALUES (1, 100);
INSERT INTO CityCapacities (city_id, max_capacity) VALUES (2, 200);
INSERT INTO CityCapacities (city_id, max_capacity) VALUES (3, 300);

-- Realistic data for City
INSERT INTO City (city_id, city_demand) VALUES (1, 50);
INSERT INTO City (city_id, city_demand) VALUES (2, 150);
INSERT INTO City (city_id, city_demand) VALUES (3, 250);

-- Realistic data for QuantityShipped
INSERT INTO QuantityShipped (city_id, quantity) VALUES (1, 60.0);
INSERT INTO QuantityShipped (city_id, quantity) VALUES (2, 150.0);
INSERT INTO QuantityShipped (city_id, quantity) VALUES (3, 290.0);
```