# Complete Optimization Problem and Solution: wrestler

## 1. Problem Context and Goals

### Context  
The objective is to optimize the assignment of wrestlers to various events in a manner that maximizes the total number of days titles are held. This involves making strategic decisions about which wrestlers participate in which events. Each decision is represented by a binary choice: whether a wrestler is assigned to a specific event. The operational parameters include the maximum number of events a wrestler can participate in and the maximum number of participants allowed per event. These parameters are crucial for ensuring that the assignments adhere to the constraints of wrestler availability and event capacity. The business configuration specifies that each wrestler can participate in a limited number of events, and each event can accommodate a limited number of wrestlers. This setup ensures that the optimization problem remains linear, focusing on maximizing the total days titles are held without involving complex nonlinear relationships.

### Goals  
The primary goal of this optimization problem is to maximize the total number of days that titles are held by wrestlers. This is achieved by strategically assigning wrestlers to events, with the aim of maximizing the cumulative days titles are held across all assignments. The success of this optimization is measured by the total days titles are held, which is directly influenced by the assignments made. The goal is articulated in a linear fashion, focusing on maximizing the sum of the days titles are held, as determined by the assignments of wrestlers to events.

## 2. Constraints    

The constraints for this optimization problem are designed to ensure that the assignments of wrestlers to events are feasible and adhere to the operational limits. Each wrestler can only participate in a limited number of events, as specified by their maximum event participation capacity. Similarly, each event can only accommodate a certain number of participants, ensuring that the event remains competitive and engaging. These constraints are expressed in a linear form, ensuring that the problem remains within the realm of linear optimization. Specifically, the constraints are:
- Each wrestler can participate in no more than their maximum allowed number of events.
- Each event can have no more participants than its maximum capacity allows.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, modifying existing tables to fill mapping gaps, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE Wrestler (
  WrestlerID INTEGER,
  Days_held INTEGER,
  MaxEvents INTEGER
);

CREATE TABLE WrestlerEventAssignment (
  WrestlerID INTEGER,
  EventID INTEGER,
  Assigned BOOLEAN
);

CREATE TABLE EventConstraints (
  EventID INTEGER,
  MaxParticipants INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in this optimization problem, detailing their business purposes and roles in the optimization process:

- **Wrestler Table**: This table stores information about each wrestler, including their unique identifier, the number of days they hold a title, and the maximum number of events they can participate in. The data in this table is used to determine the objective coefficients and constraint bounds for wrestler participation.

- **WrestlerEventAssignment Table**: This table tracks the assignments of wrestlers to events. It includes the wrestler's identifier, the event's identifier, and a binary indicator of whether the wrestler is assigned to the event. This table is crucial for defining the decision variables in the optimization problem.

- **EventConstraints Table**: This table contains constraints related to event participation, including the event's identifier and the maximum number of participants allowed. The data in this table is used to establish the constraint bounds for event participation.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical wrestling event structures and participation limits, ensuring a balance between wrestler availability and event capacity.

-- Realistic data for Wrestler
INSERT INTO Wrestler (WrestlerID, Days_held, MaxEvents) VALUES (1, 30, 5);
INSERT INTO Wrestler (WrestlerID, Days_held, MaxEvents) VALUES (2, 45, 6);
INSERT INTO Wrestler (WrestlerID, Days_held, MaxEvents) VALUES (3, 60, 7);

-- Realistic data for WrestlerEventAssignment
INSERT INTO WrestlerEventAssignment (WrestlerID, EventID, Assigned) VALUES (1, 101, True);
INSERT INTO WrestlerEventAssignment (WrestlerID, EventID, Assigned) VALUES (2, 102, True);
INSERT INTO WrestlerEventAssignment (WrestlerID, EventID, Assigned) VALUES (3, 103, True);
INSERT INTO WrestlerEventAssignment (WrestlerID, EventID, Assigned) VALUES (1, 102, False);
INSERT INTO WrestlerEventAssignment (WrestlerID, EventID, Assigned) VALUES (2, 103, False);

-- Realistic data for EventConstraints
INSERT INTO EventConstraints (EventID, MaxParticipants) VALUES (101, 10);
INSERT INTO EventConstraints (EventID, MaxParticipants) VALUES (102, 12);
INSERT INTO EventConstraints (EventID, MaxParticipants) VALUES (103, 15);
```