# Complete Optimization Problem and Solution: wta_1

## 1. Problem Context and Goals

### Context  
The objective is to optimize the scheduling of tennis matches in a tournament to minimize the total travel distance for players. Each player is assigned to matches, and the decision variable is whether a player is assigned to a specific match. The operational parameters include minimizing the total travel distance, which is calculated by summing the travel distances for each player to their assigned matches. The business configuration includes the total available time for a player to participate in matches, which serves as a constraint in the optimization model. The travel distance between a player's location and the match location is determined using a predefined formula, ensuring that the calculation method aligns with the objective coefficients in the optimization model. The focus is on precise operational decision-making that leads to linear formulations, avoiding any nonlinear relationships. Resource limitations are expressed as linear constraints, and specific operational parameters are mapped to expected coefficient sources. The business configuration parameters, including scalar parameters and business logic formulas, are integral to the model.

### Goals  
The primary goal is to minimize the total travel distance for players participating in the tournament. This involves optimizing the assignment of players to matches such that the sum of the travel distances is minimized. Success is measured by the reduction in total travel distance, aligning with the expected coefficient sources. The optimization goal is clearly defined in natural language, focusing on minimizing the travel distance without using mathematical formulas or symbolic notation.

## 2. Constraints    

The constraints are designed to ensure that the optimization problem remains linear and solvable. The first constraint ensures that the total time a player spends in matches does not exceed their available time. This is expressed as the sum of the time spent in each match for a player being less than or equal to their available time. The second constraint ensures that each match has exactly one player assigned to it. These constraints are described in business terms, naturally leading to linear mathematical forms without involving variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for travel distances and player availability, modifying existing tables for better mapping, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE travel_distances (
  player_id INTEGER,
  match_num INTEGER,
  distance FLOAT
);

CREATE TABLE player_availability (
  player_id INTEGER,
  available_time INTEGER
);

CREATE TABLE matches (
  match_num INTEGER,
  minutes INTEGER,
  player_id INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles. 

- **Travel Distances Table**: This table stores the travel distances for players between match locations. It plays a critical role in determining the objective coefficients for the optimization model. Each entry includes a player identifier, a match identifier, and the travel distance, which is used to calculate the total travel distance.

- **Player Availability Table**: This table records the total available time each player has to participate in matches. It serves as a constraint bound in the optimization model, ensuring that players do not exceed their available time when assigned to matches.

- **Matches Table**: This table contains details about each match, including its duration and the player assigned to it. The match duration is used as a constraint bound, while the player assignment is a decision variable in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical tournament schedules, player travel patterns, and match durations to ensure a realistic and solvable optimization problem.

-- Realistic data for travel_distances
INSERT INTO travel_distances (player_id, match_num, distance) VALUES (1, 101, 12.5);
INSERT INTO travel_distances (player_id, match_num, distance) VALUES (2, 102, 18.0);
INSERT INTO travel_distances (player_id, match_num, distance) VALUES (3, 103, 8.0);

-- Realistic data for player_availability
INSERT INTO player_availability (player_id, available_time) VALUES (1, 150);
INSERT INTO player_availability (player_id, available_time) VALUES (2, 180);
INSERT INTO player_availability (player_id, available_time) VALUES (3, 120);

-- Realistic data for matches
INSERT INTO matches (match_num, minutes, player_id) VALUES (101, 90, 1);
INSERT INTO matches (match_num, minutes, player_id) VALUES (102, 120, 2);
INSERT INTO matches (match_num, minutes, player_id) VALUES (103, 60, 3);
```