# Complete Optimization Problem and Solution: activity_1

## 1. Problem Context and Goals

### Context  
A university is managing the allocation of students and faculty to extracurricular activities with the goal of maximizing overall participation. The decision-making process involves determining which students and faculty members should participate in which activities. Each student can participate in at most one activity, and each faculty member can participate in at most two activities. Additionally, each activity has a predefined maximum number of participants that cannot be exceeded.  

The business configuration includes the following operational parameters:  
- **Faculty Availability Limit**: Faculty members are limited to participating in a maximum of two activities to balance their workload and ensure availability.  
- **Student Preference Threshold**: Students are allowed to participate in only one activity to ensure focused engagement and avoid overcommitment.  
- **Total Participation Calculation**: The total participation in an activity is calculated as the sum of student and faculty participation in that activity.  

The optimization problem is designed to ensure that these constraints are respected while maximizing the total number of participants across all activities.  

### Goals  
The primary goal of this optimization problem is to maximize the total participation in extracurricular activities by both students and faculty. Success is measured by the total number of participants across all activities, which is the sum of student and faculty participation. This goal aligns with the operational parameters and ensures that the allocation respects the constraints on faculty availability, student preferences, and activity capacity limits.  

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. **Student Participation Limit**: Each student can participate in at most one activity. This ensures that students are not overcommitted and can focus on their chosen activity.  
2. **Faculty Participation Limit**: Each faculty member can participate in at most two activities. This constraint balances faculty workload and ensures their availability across activities.  
3. **Activity Capacity Limit**: The total number of participants in each activity, including both students and faculty, must not exceed the predefined maximum capacity for that activity. This ensures that activities are not overcrowded and can operate effectively.  

These constraints are designed to ensure that the allocation of participants is feasible and aligns with the operational capabilities of the university.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Added Activity_Capacity table to address missing max_participants constraint. Updated business_configuration_logic.json with scalar parameters and formulas. Ensured schema follows normalization principles and industry standards.

CREATE TABLE Participates_in (
  stuid INTEGER,
  actid INTEGER
);

CREATE TABLE Faculty_Participates_in (
  FacID INTEGER,
  actid INTEGER
);

CREATE TABLE Activity_Capacity (
  actid INTEGER,
  max_participants INTEGER
);
```

### Data Dictionary  
- **Participates_in**: Tracks student participation in activities.  
  - **stuid**: Unique identifier for a student. Used to determine which students participate in which activities.  
  - **actid**: Unique identifier for an activity. Used to link students to specific activities.  
- **Faculty_Participates_in**: Tracks faculty participation in activities.  
  - **FacID**: Unique identifier for a faculty member. Used to determine which faculty members participate in which activities.  
  - **actid**: Unique identifier for an activity. Used to link faculty members to specific activities.  
- **Activity_Capacity**: Defines the maximum number of participants allowed in each activity.  
  - **actid**: Unique identifier for an activity. Used to link capacity limits to specific activities.  
  - **max_participants**: The maximum number of participants allowed in the activity. Used to enforce capacity constraints.  


### Retrieved Values

**Query 1: This is important for understanding the current student participation distribution across activities, which is crucial for optimizing the allocation.**

```sql
SELECT actid, COUNT(stuid) AS student_count FROM Participates_in GROUP BY actid;
```

**Results (CSV format):**
```csv
actid,student_count
1,1
2,1
3,1
```

**Query 2: This is important for understanding the current faculty participation distribution across activities, which is crucial for optimizing the allocation.**

```sql
SELECT actid, COUNT(FacID) AS faculty_count FROM Faculty_Participates_in GROUP BY actid;
```

**Results (CSV format):**
```csv
actid,faculty_count
1,1
2,1
3,1
```

**Query 3: This is essential for ensuring that the total number of participants (students + faculty) does not exceed the predefined capacity for each activity.**

```sql
SELECT actid, max_participants FROM Activity_Capacity;
```

**Results (CSV format):**
```csv
actid,max_participants
1,10
2,15
3,20
```

**Query 4: This is important for understanding the current total participation in each activity, which is crucial for ensuring that the capacity constraints are not violated.**

```sql
SELECT p.actid, COUNT(p.stuid) + COUNT(f.FacID) AS total_participation FROM Participates_in p FULL JOIN Faculty_Participates_in f ON p.actid = f.actid GROUP BY p.actid;
```

**Results (CSV format):**
```csv
actid,total_participation
1,2
2,2
3,2
```

**Query 5: This is important for identifying students who can be allocated to activities to maximize participation.**

```sql
SELECT stuid FROM Participates_in WHERE stuid NOT IN (SELECT stuid FROM Participates_in);
```

**Results (CSV format):**
```csv
stuid
```

**Query 6: This is important for identifying faculty members who can be allocated to additional activities to maximize participation.**

```sql
SELECT FacID FROM Faculty_Participates_in GROUP BY FacID HAVING COUNT(actid) < 2;
```

**Results (CSV format):**
```csv
FacID
201
202
203
```

**Query 7: This is important for identifying activities that can still accommodate more participants.**

```sql
SELECT p.actid, COUNT(p.stuid) + COUNT(f.FacID) AS total_participation FROM Participates_in p FULL JOIN Faculty_Participates_in f ON p.actid = f.actid GROUP BY p.actid ) tp ON ac.actid = tp.actid WHERE tp.total_participation < ac.max_participants OR tp.total_participation IS NULL;
```

**Error:** Execution failed on sql 'SELECT p.actid, COUNT(p.stuid) + COUNT(f.FacID) AS total_participation FROM Participates_in p FULL JOIN Faculty_Participates_in f ON p.actid = f.actid GROUP BY p.actid ) tp ON ac.actid = tp.actid WHERE tp.total_participation < ac.max_participants OR tp.total_participation IS NULL;': near ")": syntax error

**Query 8: This is important for a detailed view of participation in each activity, which is crucial for making informed allocation decisions.**

```sql
SELECT p.actid, COUNT(p.stuid) AS student_count, COUNT(f.FacID) AS faculty_count FROM Participates_in p FULL JOIN Faculty_Participates_in f ON p.actid = f.actid GROUP BY p.actid;
```

**Results (CSV format):**
```csv
actid,student_count,faculty_count
1,1,1
2,1,1
3,1,1
```

