# Complete Optimization Problem and Solution: battle_death

## 1. Problem Context and Goals

### Context  
In military operations, the allocation of ships to battles is a critical decision that directly impacts the outcome of engagements. The goal is to minimize the total number of casualties (killed and injured) across all battles by optimally deploying ships, considering their tonnage and the constraints of each battle. Each ship can only be deployed to one battle, and the total tonnage of ships deployed to a battle must not exceed the maximum tonnage allowed for that battle. The decision to deploy a ship to a specific battle is represented as a binary choice: a ship is either deployed or not. The total casualties in a battle are calculated as the sum of killed and injured personnel, which serves as the primary metric for optimization. The maximum tonnage allowed per battle is a key operational parameter that ensures realistic and feasible deployment scenarios.

### Goals  
The primary goal of this optimization problem is to minimize the total number of casualties across all battles. This is achieved by strategically deciding which ships to deploy to each battle, ensuring that the total tonnage of deployed ships does not exceed the maximum allowed for each battle. Success is measured by the reduction in the sum of killed and injured personnel across all battles, aligning with the operational objective of minimizing human losses.

## 2. Constraints    

1. **Tonnage Constraint**: For each battle, the total tonnage of all ships deployed to that battle must not exceed the maximum tonnage allowed for that battle. This ensures that the deployment of ships is within the operational capacity of each battle.

2. **Single Deployment Constraint**: Each ship can only be deployed to one battle. This ensures that ships are not overcommitted and are available for their assigned engagements.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for ship tonnage, battle constraints, and ship-to-battle deployment decisions. Configuration logic updates include scalar parameters for maximum tonnage and formulas for casualty calculations.

CREATE TABLE ship_tonnage (
  ship_id INTEGER,
  tonnage INTEGER
);

CREATE TABLE battle_constraints (
  battle_id INTEGER,
  max_tonnage INTEGER
);

CREATE TABLE ship_deployment (
  ship_id INTEGER,
  battle_id INTEGER,
  deployed BOOLEAN
);

CREATE TABLE death (
  battle_id INTEGER,
  ship_id INTEGER,
  killed INTEGER,
  injured INTEGER
);


```

### Data Dictionary  
- **ship_tonnage**: Contains the tonnage of each ship available for deployment.  
  - *ship_id*: Unique identifier for each ship.  
  - *tonnage*: Tonnage of the ship, used in the tonnage constraint.  

- **battle_constraints**: Specifies the maximum tonnage allowed per battle.  
  - *battle_id*: Unique identifier for each battle.  
  - *max_tonnage*: Maximum tonnage allowed in the battle, used as a constraint bound in the optimization model.  

- **ship_deployment**: Represents the binary decision variable indicating if a ship is deployed to a battle.  
  - *ship_id*: Unique identifier for each ship.  
  - *battle_id*: Unique identifier for each battle.  
  - *deployed*: Indicates if the ship is deployed to the battle, used as a decision variable in the optimization model.  

- **death**: Records the casualties in each battle.  
  - *battle_id*: Unique identifier for each battle.  
  - *ship_id*: Unique identifier for each ship.  
  - *killed*: Number of killed in the battle, used as an objective coefficient in the optimization model.  
  - *injured*: Number of injured in the battle, used as an objective coefficient in the optimization model.  


### Retrieved Values

**Query 1: This data is needed to ensure that the total tonnage of ships deployed to a battle does not exceed the maximum allowed tonnage.**

```sql
SELECT ship_id, tonnage FROM ship_tonnage;
```

**Results (CSV format):**
```csv
ship_id,tonnage
1,5000
2,7000
3,9000
```

**Query 2: This data is used to ensure that the total tonnage of ships deployed to a battle does not exceed the maximum allowed tonnage.**

```sql
SELECT battle_id, max_tonnage FROM battle_constraints;
```

**Results (CSV format):**
```csv
battle_id,max_tonnage
1,10000
2,12000
3,15000
```

**Query 3: This data is needed to determine which ships are deployed to which battles and to ensure that each ship is only deployed to one battle.**

```sql
SELECT ship_id, battle_id, deployed FROM ship_deployment;
```

**Results (CSV format):**
```csv
ship_id,battle_id,deployed
1,1,1
2,2,1
3,3,1
```

**Query 4: This data is used to calculate the total casualties (killed + injured) that need to be minimized across all battles.**

```sql
SELECT battle_id, ship_id, killed, injured FROM death;
```

**Results (CSV format):**
```csv
battle_id,ship_id,killed,injured
1,1,10,15
2,2,20,25
3,3,30,35
```

**Query 5: This aggregated data helps in understanding the overall impact of ship deployments on casualties.**

```sql
SELECT battle_id, SUM(killed + injured) AS total_casualties FROM death GROUP BY battle_id;
```

**Results (CSV format):**
```csv
battle_id,total_casualties
1,25
2,45
3,65
```

**Query 6: This aggregated data helps in ensuring that the total tonnage of deployed ships does not exceed the maximum allowed tonnage for each battle.**

```sql
SELECT b.battle_id, SUM(s.tonnage) AS total_deployed_tonnage FROM ship_deployment sd JOIN ship_tonnage s ON sd.ship_id = s.ship_id WHERE sd.deployed = TRUE GROUP BY b.battle_id;
```

**Error:** Execution failed on sql 'SELECT b.battle_id, SUM(s.tonnage) AS total_deployed_tonnage FROM ship_deployment sd JOIN ship_tonnage s ON sd.ship_id = s.ship_id WHERE sd.deployed = TRUE GROUP BY b.battle_id;': no such column: b.battle_id

**Query 7: This data is useful for identifying available ships that can be deployed to battles to minimize casualties.**

```sql
SELECT s.ship_id, s.tonnage FROM ship_tonnage s LEFT JOIN ship_deployment sd ON s.ship_id = sd.ship_id AND sd.deployed = TRUE WHERE sd.ship_id IS NULL;
```

**Results (CSV format):**
```csv
ship_id,tonnage
```

**Query 8: This summary data helps in understanding the total tonnage available for allocation across all battles.**

```sql
SELECT SUM(tonnage) AS total_tonnage FROM ship_tonnage;
```

**Results (CSV format):**
```csv
total_tonnage
21000
```

**Query 9: This summary data helps in understanding the total tonnage capacity needed across all battles.**

```sql
SELECT SUM(max_tonnage) AS total_max_tonnage FROM battle_constraints;
```

**Results (CSV format):**
```csv
total_max_tonnage
37000
```

**Query 10: This aggregated data helps in identifying ships that contribute the most to casualties and may need to be deployed strategically.**

```sql
SELECT ship_id, SUM(killed + injured) AS total_casualties FROM death GROUP BY ship_id;
```

**Results (CSV format):**
```csv
ship_id,total_casualties
1,25
2,45
3,65
```

