# Complete Optimization Problem and Solution: body_builder

## 1. Problem Context and Goals

### Context  
A bodybuilding competition organizer is tasked with selecting a team of bodybuilders to compete in an upcoming event. The goal is to assemble a team that maximizes the total performance score based on the bodybuilders' Snatch and Clean & Jerk scores. The selection process must adhere to specific operational constraints to ensure the team meets diversity and physical criteria.  

The organizer must decide which bodybuilders to include in the team, represented by a binary decision for each individual. The total number of bodybuilders in the team cannot exceed a predefined limit, ensuring the team remains manageable and diverse. Additionally, the team must meet a minimum average height requirement of 170 cm and a maximum average weight requirement of 100 kg. These constraints ensure the team aligns with the competition's physical standards.  

The performance scores for each bodybuilder are derived from their Snatch and Clean & Jerk results, which are stored in the database. The physical attributes of height and weight are also recorded and used to enforce the team's physical criteria. The business configuration includes a maximum team size limit of 5 bodybuilders, a minimum average height requirement, and a maximum average weight requirement, all of which are critical to the selection process.  

### Goals  
The primary goal of this optimization problem is to maximize the total performance score of the selected team. This score is calculated as the sum of the Snatch and Clean & Jerk scores of the chosen bodybuilders. Success is measured by achieving the highest possible total score while adhering to the constraints on team size, average height, and average weight.  

## 2. Constraints  

The selection of bodybuilders for the team must respect the following constraints:  
1. **Team Size Limit**: The total number of bodybuilders selected for the team must not exceed the predefined limit of 5. This ensures the team remains manageable and diverse.  
2. **Minimum Average Height**: The average height of the selected bodybuilders must be at least 170 cm. This ensures the team meets the competition's physical standards for height.  
3. **Maximum Average Weight**: The average weight of the selected bodybuilders must not exceed 100 kg. This ensures the team aligns with the competition's physical standards for weight.  

These constraints are designed to ensure the team is both competitive and compliant with the competition's requirements.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding a table for decision variables and updating configuration logic to handle team size constraints and business metrics.

CREATE TABLE body_builder (
  Snatch FLOAT,
  Clean_Jerk FLOAT
);

CREATE TABLE people (
  Height FLOAT,
  Weight FLOAT
);

CREATE TABLE team_selection (
  is_selected BOOLEAN
);
```

### Data Dictionary  
- **body_builder Table**:  
  - **Snatch**: The Snatch score of a bodybuilder, used to calculate the total performance score.  
  - **Clean_Jerk**: The Clean & Jerk score of a bodybuilder, used to calculate the total performance score.  

- **people Table**:  
  - **Height**: The height of a bodybuilder in centimeters, used to enforce the minimum average height constraint.  
  - **Weight**: The weight of a bodybuilder in kilograms, used to enforce the maximum average weight constraint.  

- **team_selection Table**:  
  - **is_selected**: A binary indicator of whether a bodybuilder is selected for the team, representing the decision variable in the optimization model.  


### Retrieved Values

**Query 1: This data is crucial for calculating the total performance score, which is the objective function to maximize.**

```sql
SELECT Snatch, Clean_Jerk FROM body_builder;
```

**Results (CSV format):**
```csv
Snatch,Clean_Jerk
150.5,200.0
160.0,210.5
170.5,220.0
```

**Query 2: This data is necessary to enforce the constraints on average height and average weight.**

```sql
SELECT Height, Weight FROM people;
```

**Results (CSV format):**
```csv
Height,Weight
175.0,90.0
180.0,95.0
185.0,100.0
```

**Query 3: This data represents the decision variables in the optimization model, indicating whether a bodybuilder is selected for the team.**

```sql
SELECT is_selected FROM team_selection;
```

**Results (CSV format):**
```csv
is_selected
1
0
1
```

**Query 4: This aggregated data helps in evaluating the potential contribution of each bodybuilder to the team's total score.**

```sql
SELECT Snatch + Clean_Jerk AS Total_Performance_Score FROM body_builder;
```

**Results (CSV format):**
```csv
Total_Performance_Score
350.5
370.5
390.5
```

**Query 5: This summary statistic is useful for understanding the overall physical attributes of the bodybuilders and ensuring the team meets the constraints.**

```sql
SELECT AVG(Height) AS Average_Height, AVG(Weight) AS Average_Weight FROM people;
```

**Results (CSV format):**
```csv
Average_Height,Average_Weight
180.0,95.0
```

**Query 6: This count is necessary to enforce the team size constraint.**

```sql
SELECT COUNT(*) AS Total_Selected FROM team_selection WHERE is_selected = TRUE;
```

**Results (CSV format):**
```csv
Total_Selected
2
```

**Query 7: These averages are critical for enforcing the minimum average height and maximum average weight constraints.**

```sql
SELECT AVG(p.Height) AS Average_Height_Selected, AVG(p.Weight) AS Average_Weight_Selected FROM team_selection t JOIN people p ON t.id = p.id WHERE t.is_selected = TRUE;  -- Assuming there is an 'id' column to join the tables;
```

**Error:** Execution failed on sql 'SELECT AVG(p.Height) AS Average_Height_Selected, AVG(p.Weight) AS Average_Weight_Selected FROM team_selection t JOIN people p ON t.id = p.id WHERE t.is_selected = TRUE;  -- Assuming there is an 'id' column to join the tables;': no such column: t.id

