# Complete Optimization Problem and Solution: city_record

## 1. Problem Context and Goals

### Context  
A sports organization is tasked with selecting the optimal set of host cities for a series of matches in a given year. The decision-making process is guided by a set of key factors: the regional population of each city, its GDP, and the average temperature during the match month. These factors are weighted to reflect their relative importance in determining the overall benefit of selecting a city as a host. The weights are as follows: 40% for population, 30% for GDP, and 30% for temperature. The organization must also adhere to several operational constraints: the total number of matches to be hosted is capped at 10, the total budget for hosting cannot exceed $1,000,000, and no single city can host more than 2 matches. The goal is to maximize the overall benefit of the selected host cities while respecting these constraints.

### Goals  
The primary goal of this optimization problem is to maximize the total benefit derived from selecting host cities for the matches. This benefit is calculated as a weighted sum of each city's regional population, GDP, and average temperature during the match month. The weights assigned to these factors ensure that the selection process aligns with the organization's priorities. Success is measured by the ability to select a set of cities that collectively provide the highest possible benefit without exceeding the total number of matches, the budget, or the maximum number of matches per city.

## 2. Constraints    

The optimization process must respect the following constraints:  
1. **Total Matches Constraint**: The total number of matches hosted across all selected cities must not exceed 10.  
2. **Budget Constraint**: The total cost of hosting matches in the selected cities must not exceed the allocated budget of $1,000,000.  
3. **Maximum Matches Per City Constraint**: No single city can host more than 2 matches.  

These constraints ensure that the selection process remains feasible and aligns with the organization's operational limitations.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for city data, match constraints, and objective coefficients. Configuration logic updates include scalar parameters for weights and constraints, and formulas for benefit calculation.

CREATE TABLE city_data (
  city_id INTEGER,
  population INTEGER,
  gdp FLOAT,
  avg_temperature FLOAT,
  hosting_cost FLOAT
);

CREATE TABLE match_constraints (
  constraint_id INTEGER,
  max_matches_per_city INTEGER,
  total_budget FLOAT
);

CREATE TABLE objective_coefficients (
  coefficient_id INTEGER,
  weight_population FLOAT,
  weight_gdp FLOAT,
  weight_temperature FLOAT
);
```

### Data Dictionary  
- **city_data**: Contains information about potential host cities, including their unique identifier, regional population, GDP, average temperature during the match month, and the cost of hosting a match in the city.  
  - **city_id**: Unique identifier for each city.  
  - **population**: Regional population of the city, used as a component in the benefit calculation.  
  - **gdp**: GDP of the city, used as a component in the benefit calculation.  
  - **avg_temperature**: Average temperature during the match month, used as a component in the benefit calculation.  
  - **hosting_cost**: Cost of hosting a match in the city, used to enforce the budget constraint.  

- **match_constraints**: Stores operational constraints related to hosting matches, including the maximum number of matches per city and the total budget.  
  - **constraint_id**: Unique identifier for each constraint.  
  - **max_matches_per_city**: Maximum number of matches that can be hosted in a single city.  
  - **total_budget**: Total budget allocated for hosting matches across all cities.  

- **objective_coefficients**: Contains the weights assigned to each factor in the benefit calculation.  
  - **coefficient_id**: Unique identifier for each coefficient.  
  - **weight_population**: Weight assigned to the regional population in the benefit calculation (40%).  
  - **weight_gdp**: Weight assigned to the GDP in the benefit calculation (30%).  
  - **weight_temperature**: Weight assigned to the average temperature in the benefit calculation (30%).  


### Retrieved Values

**Query 1: Query Description: Retrieve all city data including population, GDP, average temperature, and hosting cost. This data is essential for calculating the benefit of selecting each city as a host and for enforcing the budget constraint.**

```sql
SELECT city_id, population, gdp, avg_temperature, hosting_cost FROM city_data;
```

**Results (CSV format):**
```csv
city_id,population,gdp,avg_temperature,hosting_cost
1,800000,75000.0,22.0,120000.0
2,1200000,110000.0,26.0,180000.0
3,600000,60000.0,20.0,100000.0
```

**Query 2: Query Description: Retrieve the objective coefficients (weights) for population, GDP, and temperature. These weights are crucial for calculating the weighted benefit of each city.**

```sql
SELECT weight_population, weight_gdp, weight_temperature FROM objective_coefficients;
```

**Results (CSV format):**
```csv
weight_population,weight_gdp,weight_temperature
0.4,0.3,0.3
0.4,0.3,0.3
0.4,0.3,0.3
```

**Query 3: Query Description: Retrieve the operational constraints, including the maximum number of matches per city and the total budget. These constraints are necessary to ensure the solution is feasible.**

```sql
SELECT max_matches_per_city, total_budget FROM match_constraints;
```

**Results (CSV format):**
```csv
max_matches_per_city,total_budget
2,1000000.0
2,1000000.0
2,1000000.0
```

**Query 4: Query Description: Calculate the weighted benefit for each city using the objective coefficients. This query combines city data with the weights to compute the benefit score, which is the primary metric for optimization.**

```sql
SELECT cd.city_id, (cd.population * oc.weight_population) + (cd.gdp * oc.weight_gdp) + (cd.avg_temperature * oc.weight_temperature) AS benefit_score FROM city_data cd CROSS JOIN objective_coefficients oc;
```

**Results (CSV format):**
```csv
city_id,benefit_score
1,342506.6
1,342506.6
1,342506.6
2,513007.8
2,513007.8
2,513007.8
3,258006.0
3,258006.0
3,258006.0
```

**Query 5: Query Description: Retrieve the total hosting cost for all cities. This is useful for ensuring that the total budget constraint is not exceeded when selecting host cities.**

```sql
SELECT SUM(hosting_cost) AS total_hosting_cost FROM city_data;
```

**Results (CSV format):**
```csv
total_hosting_cost
400000.0
```

**Query 6: Query Description: Retrieve the number of matches each city can host, considering the maximum matches per city constraint. This helps in ensuring that no city exceeds its allowed number of matches.**

```sql
SELECT city_id, LEAST(2, max_matches_per_city) AS max_matches_allowed FROM city_data CROSS JOIN match_constraints;
```

**Error:** Execution failed on sql 'SELECT city_id, LEAST(2, max_matches_per_city) AS max_matches_allowed FROM city_data CROSS JOIN match_constraints;': no such function: LEAST

**Query 7: Query Description: Retrieve the top 10 cities with the highest benefit scores. This query helps in identifying the most beneficial cities that could be selected as hosts, considering the total matches constraint.**

```sql
SELECT cd.city_id, (cd.population * oc.weight_population) + (cd.gdp * oc.weight_gdp) + (cd.avg_temperature * oc.weight_temperature) AS benefit_score FROM city_data cd CROSS JOIN objective_coefficients oc ORDER BY benefit_score DESC LIMIT 10;
```

**Results (CSV format):**
```csv
city_id,benefit_score
2,513007.8
2,513007.8
2,513007.8
1,342506.6
1,342506.6
1,342506.6
3,258006.0
3,258006.0
3,258006.0
```

**Query 8: Query Description: Retrieve the total benefit score for the top 10 cities. This query helps in evaluating the overall benefit of selecting the top 10 cities as hosts.**

```sql
SELECT SUM((cd.population * oc.weight_population) + (cd.gdp * oc.weight_gdp) + (cd.avg_temperature * oc.weight_temperature)) AS total_benefit_score FROM city_data cd CROSS JOIN objective_coefficients oc ORDER BY (cd.population * oc.weight_population) + (cd.gdp * oc.weight_gdp) + (cd.avg_temperature * oc.weight_temperature) DESC LIMIT 10;
```

**Results (CSV format):**
```csv
total_benefit_score
3340561.1999999997
```

**Query 9: Query Description: Retrieve the total hosting cost for the top 10 cities. This query helps in ensuring that the total budget constraint is not exceeded when selecting the top 10 cities.**

```sql
SELECT cd.city_id FROM city_data cd CROSS JOIN objective_coefficients oc ORDER BY (cd.population * oc.weight_population) + (cd.gdp * oc.weight_gdp) + (cd.avg_temperature * oc.weight_temperature) DESC LIMIT 10 );
```

**Error:** Execution failed on sql 'SELECT cd.city_id FROM city_data cd CROSS JOIN objective_coefficients oc ORDER BY (cd.population * oc.weight_population) + (cd.gdp * oc.weight_gdp) + (cd.avg_temperature * oc.weight_temperature) DESC LIMIT 10 );': near ")": syntax error

