# Complete Optimization Problem and Solution: decoration_competition

## 1. Problem Context and Goals

### Context  
In a college decoration competition, each college sends members to participate in rounds with different themes. The goal is to maximize the overall ranking of a college by strategically assigning members to rounds based on their strengths in specific themes. The decision to assign a member to a round is represented by a binary indicator, which is either true (assigned) or false (not assigned).  

The ranking points a member achieves in a specific round are determined by their performance in that round. These ranking points are used to calculate the total ranking points for the college, which is the metric to be maximized.  

Operational parameters include:  
- **Member Limit**: Each member can participate in a maximum of 2 rounds to ensure balanced participation and prevent overcommitment.  
- **Round Requirement**: Each round requires exactly 2 participants to ensure healthy competition and engagement.  

The business logic for calculating ranking points is straightforward: the ranking points a member achieves in a specific round are directly used in the objective function to maximize the total ranking points.  

### Goals  
The optimization goal is to maximize the total ranking points of the college by assigning members to rounds in a way that leverages their strengths in specific decoration themes. Success is measured by the sum of the ranking points achieved by all assigned members across all rounds.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Member Participation Limit**: Each member can be assigned to no more than 2 rounds. This ensures that no member is overcommitted and participation is balanced across all members.  
2. **Round Participant Requirement**: Each round must have exactly 2 participants. This ensures that every round has the required number of participants to maintain competition and engagement.  

These constraints are designed to ensure fair and balanced participation while achieving the optimization goal.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added a new table for ranking points to address the missing optimization requirement. Updated business configuration logic to include scalar parameters and formulas. Ensured all tables meet the 3-row minimum rule.

CREATE TABLE assignment_indicator (
  Member_ID INTEGER,
  Round_ID INTEGER,
  Assignment_Indicator BOOLEAN
);

CREATE TABLE member_limit (
  Member_ID INTEGER,
  Member_Limit INTEGER
);

CREATE TABLE round_requirement (
  Round_ID INTEGER,
  Round_Requirement INTEGER
);

CREATE TABLE rank_in_round (
  Member_ID INTEGER,
  Round_ID INTEGER,
  Rank_in_Round INTEGER
);
```

### Data Dictionary  
- **assignment_indicator**: Tracks which members are assigned to which rounds.  
  - **Member_ID**: Unique identifier for a member.  
  - **Round_ID**: Unique identifier for a round.  
  - **Assignment_Indicator**: Indicates if the member is assigned to the round (true or false).  

- **member_limit**: Stores the maximum number of rounds each member can participate in.  
  - **Member_ID**: Unique identifier for a member.  
  - **Member_Limit**: The maximum number of rounds the member can participate in.  

- **round_requirement**: Stores the number of participants required for each round.  
  - **Round_ID**: Unique identifier for a round.  
  - **Round_Requirement**: The number of participants required for the round.  

- **rank_in_round**: Stores the ranking points a member achieves in a specific round.  
  - **Member_ID**: Unique identifier for a member.  
  - **Round_ID**: Unique identifier for a round.  
  - **Rank_in_Round**: The ranking points a member achieves in a specific round.  


### Retrieved Values

**Query 1: Query Description: Retrieve the ranking points for each member in each round. This data is crucial for the objective function, as it represents the performance of members in specific rounds, which we aim to maximize.**

```sql
SELECT Member_ID, Round_ID, Rank_in_Round FROM rank_in_round;
```

**Results (CSV format):**
```csv
Member_ID,Round_ID,Rank_in_Round
1,1,15
2,2,20
3,3,25
```

**Query 2: Query Description: Retrieve the assignment indicators for each member and round. This data is essential for decision variables, as it indicates whether a member is assigned to a round (true) or not (false).**

```sql
SELECT Member_ID, Round_ID, Assignment_Indicator FROM assignment_indicator;
```

**Results (CSV format):**
```csv
Member_ID,Round_ID,Assignment_Indicator
1,1,1
2,2,1
3,3,1
```

**Query 3: Query Description: Retrieve the member limits for each member. This data is important for the constraint that each member can participate in no more than 2 rounds.**

```sql
SELECT Member_ID, Member_Limit FROM member_limit;
```

**Results (CSV format):**
```csv
Member_ID,Member_Limit
1,2
2,2
3,2
```

**Query 4: Query Description: Retrieve the round requirements for each round. This data is important for the constraint that each round must have exactly 2 participants.**

```sql
SELECT Round_ID, Round_Requirement FROM round_requirement;
```

**Results (CSV format):**
```csv
Round_ID,Round_Requirement
1,2
2,2
3,2
```

**Query 5: Query Description: Retrieve the total ranking points for each member across all rounds. This aggregated data helps in understanding the overall performance of each member, which can be useful for strategic assignment.**

```sql
SELECT Member_ID, SUM(Rank_in_Round) AS Total_Ranking_Points FROM rank_in_round GROUP BY Member_ID;
```

**Results (CSV format):**
```csv
Member_ID,Total_Ranking_Points
1,15
2,20
3,25
```

**Query 6: Query Description: Retrieve the total ranking points for each round across all members. This aggregated data helps in understanding the overall performance of each round, which can be useful for strategic assignment.**

```sql
SELECT Round_ID, SUM(Rank_in_Round) AS Total_Ranking_Points FROM rank_in_round GROUP BY Round_ID;
```

**Results (CSV format):**
```csv
Round_ID,Total_Ranking_Points
1,15
2,20
3,25
```

**Query 7: Query Description: Retrieve the number of rounds each member is currently assigned to. This data is important for ensuring that the member participation limit constraint is not violated.**

```sql
SELECT Member_ID, COUNT(Round_ID) AS Assigned_Rounds FROM assignment_indicator WHERE Assignment_Indicator = TRUE GROUP BY Member_ID;
```

**Results (CSV format):**
```csv
Member_ID,Assigned_Rounds
1,1
2,1
3,1
```

**Query 8: Query Description: Retrieve the number of participants currently assigned to each round. This data is important for ensuring that the round participant requirement constraint is not violated.**

```sql
SELECT Round_ID, COUNT(Member_ID) AS Assigned_Participants FROM assignment_indicator WHERE Assignment_Indicator = TRUE GROUP BY Round_ID;
```

**Results (CSV format):**
```csv
Round_ID,Assigned_Participants
1,1
2,1
3,1
```

**Query 9: Query Description: Retrieve the ranking points for members who are currently assigned to rounds. This data helps in evaluating the current performance of assigned members.**

```sql
SELECT a.Member_ID, a.Round_ID, r.Rank_in_Round FROM assignment_indicator a JOIN rank_in_round r ON a.Member_ID = r.Member_ID AND a.Round_ID = r.Round_ID WHERE a.Assignment_Indicator = TRUE;
```

**Results (CSV format):**
```csv
Member_ID,Round_ID,Rank_in_Round
1,1,15
2,2,20
3,3,25
```

**Query 10: Query Description: Retrieve the ranking points for members who are not currently assigned to any round. This data helps in identifying potential candidates for assignment to improve overall ranking points.**

```sql
SELECT r.Member_ID, r.Round_ID, r.Rank_in_Round FROM rank_in_round r LEFT JOIN assignment_indicator a ON r.Member_ID = a.Member_ID AND r.Round_ID = a.Round_ID WHERE a.Assignment_Indicator IS NULL OR a.Assignment_Indicator = FALSE;
```

**Results (CSV format):**
```csv
Member_ID,Round_ID,Rank_in_Round
```

