# Complete Optimization Problem and Solution: dorm_1

## 1. Problem Context and Goals

### Context  
The dormitory assignment problem involves optimizing the allocation of students to dormitories based on specific operational criteria. The primary business decision is whether to assign a student to a particular dorm, represented as a binary choice. The goal is to minimize the total distance students travel from their home cities to their assigned dorms. This distance is a key operational parameter, as it directly impacts the objective function. 

The problem must respect two critical constraints:  
1. **Dorm Capacity**: Each dorm has a maximum number of students it can accommodate, and this limit must not be exceeded.  
2. **Gender Matching**: Students can only be assigned to dorms that match their gender.  

The data used in this optimization includes the distance between each student's home city and each dorm, the capacity of each dorm, and the gender constraints for both students and dorms. These parameters are stored in the database and are essential for calculating the objective and enforcing constraints.

### Goals  
The optimization goal is to minimize the total distance traveled by all students to their assigned dorms. This is achieved by ensuring that each student is assigned to exactly one dorm, while respecting dorm capacities and gender constraints. Success is measured by the total distance metric, which is calculated as the sum of the distances for all assigned student-dorm pairs. The objective is linear, as it involves summing the product of binary assignment decisions and their corresponding distances.

## 2. Constraints  

The optimization problem is subject to the following constraints, described in business terms:  
1. **Single Assignment**: Each student must be assigned to exactly one dorm. This ensures that all students have a place to stay and no student is left unassigned.  
2. **Dorm Capacity**: The number of students assigned to a dorm cannot exceed its maximum capacity. This ensures that dorms are not overcrowded and can accommodate all assigned students comfortably.  
3. **Gender Matching**: A student can only be assigned to a dorm if the dorm's gender constraint matches the student's gender. This ensures that gender-specific dorm policies are respected.  

These constraints are linear in nature, as they involve sums of binary variables and comparisons with fixed values, without requiring any nonlinear relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added Assignment table for decision variables, updated data dictionary, and ensured all optimization mappings are complete.

CREATE TABLE DistanceMatrix (
  student_id INTEGER,
  dorm_id INTEGER,
  distance FLOAT
);

CREATE TABLE GenderInfo (
  student_id INTEGER,
  dorm_id INTEGER,
  gender STRING
);

CREATE TABLE Dorm (
  dorm_id INTEGER,
  student_capacity INTEGER,
  gender STRING
);

CREATE TABLE Assignment (
  student_id INTEGER,
  dorm_id INTEGER,
  assign BOOLEAN
);
```

### Data Dictionary  
The following tables and columns are used in the optimization problem, with their business purposes and optimization roles clearly defined:  

- **DistanceMatrix**:  
  - **student_id**: Unique identifier for a student, linking them to their home city.  
  - **dorm_id**: Unique identifier for a dorm, linking it to its location.  
  - **distance**: The distance from a student's home city to a dorm, used in the objective function to minimize total travel distance.  

- **GenderInfo**:  
  - **student_id**: Unique identifier for a student, linking them to their gender.  
  - **dorm_id**: Unique identifier for a dorm, linking it to its gender constraint.  
  - **gender**: The gender of a student or the gender constraint of a dorm, used to enforce gender matching.  

- **Dorm**:  
  - **dorm_id**: Unique identifier for a dorm, linking it to its capacity and gender constraint.  
  - **student_capacity**: The maximum number of students a dorm can accommodate, used in capacity constraints.  
  - **gender**: The gender constraint for a dorm, used to enforce gender matching.  

- **Assignment**:  
  - **student_id**: Unique identifier for a student, linking them to their assignment.  
  - **dorm_id**: Unique identifier for a dorm, linking it to its assignment.  
  - **assign**: A binary variable indicating whether a student is assigned to a dorm, used as the decision variable in the optimization.  


### Retrieved Values

**Query 1: This is crucial for the objective function, as it provides the distances to minimize.**

```sql
SELECT student_id, dorm_id, distance FROM DistanceMatrix;
```

**Results (CSV format):**
```csv
student_id,dorm_id,distance
1,1,12.5
1,2,18.3
2,1,15.0
2,2,10.2
3,1,20.1
3,2,14.7
```

**Query 2: This is essential for enforcing the gender matching constraint.**

```sql
SELECT student_id, dorm_id, gender FROM GenderInfo;
```

**Results (CSV format):**
```csv
student_id,dorm_id,gender
1,1,Male
2,2,Female
3,1,Male
```

**Query 3: This is necessary for enforcing the dorm capacity and gender matching constraints.**

```sql
SELECT dorm_id, student_capacity, gender FROM Dorm;
```

**Results (CSV format):**
```csv
dorm_id,student_capacity,gender
1,100,Male
2,150,Female
```

**Query 4: This is the decision variable in the optimization problem.**

```sql
SELECT student_id, dorm_id, assign FROM Assignment;
```

**Results (CSV format):**
```csv
student_id,dorm_id,assign
1,1,1
2,2,1
3,1,1
```

**Query 5: This helps in enforcing the dorm capacity constraint by ensuring the number of assignments does not exceed the dorm's capacity.**

```sql
SELECT dorm_id, COUNT(student_id) AS assigned_students FROM Assignment WHERE assign = TRUE GROUP BY dorm_id;
```

**Results (CSV format):**
```csv
dorm_id,assigned_students
1,2
2,1
```

**Query 6: This helps in ensuring the single assignment constraint by identifying unassigned students.**

```sql
SELECT student_id FROM Assignment WHERE assign = FALSE;
```

**Results (CSV format):**
```csv
student_id
```

**Query 7: This helps in identifying dorms that can still accept more students, aiding in the assignment process.**

```sql
SELECT dorm_id, COUNT(student_id) AS assigned_students FROM Assignment WHERE assign = TRUE GROUP BY dorm_id ) a ON d.dorm_id = a.dorm_id WHERE a.assigned_students < d.student_capacity OR a.assigned_students IS NULL;
```

**Error:** Execution failed on sql 'SELECT dorm_id, COUNT(student_id) AS assigned_students FROM Assignment WHERE assign = TRUE GROUP BY dorm_id ) a ON d.dorm_id = a.dorm_id WHERE a.assigned_students < d.student_capacity OR a.assigned_students IS NULL;': near ")": syntax error

**Query 8: This helps in ensuring that only valid assignments are considered based on gender.**

```sql
SELECT gi.student_id, gi.dorm_id FROM GenderInfo gi JOIN Dorm d ON gi.dorm_id = d.dorm_id WHERE gi.gender = d.gender;
```

**Results (CSV format):**
```csv
student_id,dorm_id
1,1
2,2
3,1
```

**Query 9: This helps in identifying feasible assignments for the optimization problem.**

```sql
SELECT dorm_id, COUNT(student_id) AS assigned_students FROM Assignment WHERE assign = TRUE GROUP BY dorm_id ) a ON d.dorm_id = a.dorm_id WHERE gi.gender = d.gender AND (a.assigned_students < d.student_capacity OR a.assigned_students IS NULL);
```

**Error:** Execution failed on sql 'SELECT dorm_id, COUNT(student_id) AS assigned_students FROM Assignment WHERE assign = TRUE GROUP BY dorm_id ) a ON d.dorm_id = a.dorm_id WHERE gi.gender = d.gender AND (a.assigned_students < d.student_capacity OR a.assigned_students IS NULL);': near ")": syntax error

**Query 10: This helps in evaluating the current state of the objective function.**

```sql
SELECT SUM(dm.distance) AS total_distance FROM Assignment a JOIN DistanceMatrix dm ON a.student_id = dm.student_id AND a.dorm_id = dm.dorm_id WHERE a.assign = TRUE;
```

**Results (CSV format):**
```csv
total_distance
42.8
```

