# Complete Optimization Problem and Solution: election_representative

## 1. Problem Context and Goals

### Context  
A political party is focused on maximizing the total number of seats won across multiple elections by strategically allocating campaign resources to its representatives in different states. The party must make decisions on how much campaign resources to allocate to each representative, ensuring that these allocations adhere to a total budget limit, provide a minimum level of support to each representative, and respect state-specific resource caps. The total budget available for campaign resources is set at one million units, ensuring that the party can cover all necessary allocations without exceeding its financial capacity. Each representative must receive at least one thousand units of resources to ensure a baseline level of campaign support. Additionally, the total resources allocated to representatives within any single state cannot exceed fifty thousand units, ensuring a fair distribution of resources across states. These operational parameters are designed to support a linear optimization approach, where the relationships between resource allocations and outcomes are straightforward and proportional.

### Goals  
The primary goal of this optimization problem is to maximize the total number of seats won by the party across all elections. This is achieved by strategically allocating campaign resources to representatives in a way that directly increases the likelihood of winning seats. The success of this strategy is measured by the total seats won, which is calculated as the sum of the seats won by each representative multiplied by the amount of resources allocated to them. The optimization process ensures that the party’s resource allocation decisions are aligned with its objective of maximizing electoral success while adhering to all operational constraints.

## 2. Constraints    

The optimization problem is subject to three key constraints, each designed to ensure that resource allocations are both effective and feasible. First, the total amount of resources allocated to all representatives combined must not exceed the total budget of one million units. This ensures that the party does not overspend its available financial resources. Second, each representative must receive at least one thousand units of resources, guaranteeing that every candidate receives a minimum level of campaign support. Third, the total resources allocated to representatives within any single state must not exceed fifty thousand units, ensuring that no state receives an disproportionate share of resources. These constraints are designed to be linear and proportional, supporting a straightforward optimization approach.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for decision variables and constraint bounds, moving scalar parameters to business configuration logic, and updating the data dictionary to reflect optimization mappings.

CREATE TABLE election (
  Seats INTEGER
);

CREATE TABLE resource_allocation (
  Resource_Amount FLOAT
);

CREATE TABLE state_resource_limits (
  Maximum_Resource_Allocation INTEGER
);
```

### Data Dictionary  
The database schema includes three key tables, each with a specific role in the optimization process. The `election` table stores the number of seats won by each representative, which serves as the coefficient in the objective function. The `resource_allocation` table tracks the amount of campaign resources allocated to each representative, representing the decision variables in the optimization model. The `state_resource_limits` table contains the maximum amount of resources that can be allocated to representatives within each state, serving as a constraint bound in the optimization model. Together, these tables provide the necessary data to support the linear optimization of campaign resource allocations.


### Retrieved Values

**Query 1: This data is crucial for calculating the total seats won based on resource allocations.**

```sql
SELECT Seats FROM election;
```

**Results (CSV format):**
```csv
Seats
1
2
3
```

**Query 2: This data is essential for understanding the current state of resource distribution and for making adjustments to maximize seats.**

```sql
SELECT Resource_Amount FROM resource_allocation;
```

**Results (CSV format):**
```csv
Resource_Amount
1000.0
2000.0
3000.0
```

**Query 3: This data ensures that resource allocations do not exceed state-specific caps, maintaining a fair distribution across states.**

```sql
SELECT Maximum_Resource_Allocation FROM state_resource_limits;
```

**Results (CSV format):**
```csv
Maximum_Resource_Allocation
50000
60000
70000
```

**Query 4: This helps in ensuring that the total budget constraint of one million units is not exceeded.**

```sql
SELECT SUM(Resource_Amount) AS Total_Allocated_Resources FROM resource_allocation;
```

**Results (CSV format):**
```csv
Total_Allocated_Resources
6000.0
```

**Query 5: Note: This value is a fixed constraint and may not be stored in the database, but it can be used in the optimization logic.**

```sql
SELECT 1000 AS Minimum_Resource_Allocation;
```

**Results (CSV format):**
```csv
Minimum_Resource_Allocation
1000
```

**Query 6: This provides a baseline for the optimization objective, showing the current total seats won.**

```sql
SELECT SUM(e.Seats * ra.Resource_Amount) AS Total_Seats_Won FROM election e JOIN resource_allocation ra ON e.Representative_ID = ra.Representative_ID;
```

**Error:** Execution failed on sql 'SELECT SUM(e.Seats * ra.Resource_Amount) AS Total_Seats_Won FROM election e JOIN resource_allocation ra ON e.Representative_ID = ra.Representative_ID;': no such column: e.Representative_ID

**Query 7: Note: This value is a fixed constraint and may not be stored in the database, but it can be used in the optimization logic.**

```sql
SELECT 1000000 AS Total_Budget;
```

**Results (CSV format):**
```csv
Total_Budget
1000000
```

**Query 8: This helps in verifying that the state resource limits are not exceeded.**

```sql
SELECT s.State_ID, SUM(ra.Resource_Amount) AS Total_Resources_Per_State FROM resource_allocation ra JOIN state_resource_limits s ON ra.State_ID = s.State_ID GROUP BY s.State_ID;
```

**Error:** Execution failed on sql 'SELECT s.State_ID, SUM(ra.Resource_Amount) AS Total_Resources_Per_State FROM resource_allocation ra JOIN state_resource_limits s ON ra.State_ID = s.State_ID GROUP BY s.State_ID;': no such column: s.State_ID

**Query 9: This data is useful for comparing current allocations against state-specific caps to identify any violations.**

```sql
SELECT ra.Resource_Amount, s.Maximum_Resource_Allocation FROM resource_allocation ra JOIN state_resource_limits s ON ra.State_ID = s.State_ID;
```

**Error:** Execution failed on sql 'SELECT ra.Resource_Amount, s.Maximum_Resource_Allocation FROM resource_allocation ra JOIN state_resource_limits s ON ra.State_ID = s.State_ID;': no such column: ra.State_ID

**Query 10: This data can guide strategic decisions on where to allocate more resources to maximize seats.**

```sql
SELECT s.State_ID, SUM(e.Seats) AS Total_Seats_Per_State FROM election e JOIN resource_allocation ra ON e.Representative_ID = ra.Representative_ID JOIN state_resource_limits s ON ra.State_ID = s.State_ID GROUP BY s.State_ID;
```

**Error:** Execution failed on sql 'SELECT s.State_ID, SUM(e.Seats) AS Total_Seats_Per_State FROM election e JOIN resource_allocation ra ON e.Representative_ID = ra.Representative_ID JOIN state_resource_limits s ON ra.State_ID = s.State_ID GROUP BY s.State_ID;': no such column: s.State_ID

