# Complete Optimization Problem and Solution: pets_1

## 1. Problem Context and Goals

### Context  
The university is tasked with efficiently allocating pet care resources to students based on their pets' needs and the students' demographics. The primary business decision involves determining the amount of resources to allocate to each pet, represented as a continuous variable. The operational parameters are designed to minimize the total cost of pet care, which is calculated by multiplying the cost associated with each pet type by the resources allocated to each pet. 

The business configuration includes two critical scalar parameters: the minimum resource allocation per pet, ensuring that no pet receives negative resources, and the maximum resource allocation per pet, which reflects the university's budget constraints. These parameters serve as lower and upper bounds for the decision variables, respectively. The optimization problem is designed to ensure that each pet receives adequate care based on its type, age, and weight, while the total resources allocated do not exceed the available budget and weight capacity.

### Goals  
The optimization goal is to minimize the total cost of pet care. This is achieved by efficiently allocating resources to each pet, ensuring that the sum of the costs associated with each pet type multiplied by the resources allocated to each pet is as low as possible. Success is measured by achieving the lowest possible total cost while adhering to the constraints on resource allocation and care requirements.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the allocation of resources is both feasible and adequate. Each pet must receive a minimum level of care based on its type, ensuring that no pet is neglected. Additionally, the resources allocated to each pet must not exceed the maximum care requirement for its type, preventing over-allocation. 

The total resources allocated across all pets must not exceed the university's maximum resource allocation limit, ensuring that the budget is not exceeded. Finally, each pet must receive at least the minimum resource allocation, ensuring that no pet is allocated negative resources. These constraints are designed to maintain a balance between adequate care and budget limitations.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added resource_allocation table to map decision variables, updated business configuration logic with new scalar parameters, and ensured all mappings align with OR expert's requirements.

CREATE TABLE pet_type_costs (
  pet_type STRING,
  cost FLOAT
);

CREATE TABLE pet_care_requirements (
  pet_type STRING,
  min_care FLOAT,
  max_care FLOAT
);

CREATE TABLE resource_allocation (
  pet_id STRING,
  amount FLOAT
);


```

### Data Dictionary  
- **pet_type_costs**: This table contains the cost associated with caring for each pet type. The `pet_type` column identifies the type of pet, and the `cost` column represents the cost per pet type, which is used as a coefficient in the objective function.
  
- **pet_care_requirements**: This table defines the minimum and maximum care requirements for each pet type. The `pet_type` column identifies the type of pet, while the `min_care` and `max_care` columns represent the lower and upper bounds for resource allocation, respectively.
  
- **resource_allocation**: This table tracks the amount of resources allocated to each pet. The `pet_id` column uniquely identifies each pet, and the `amount` column represents the decision variable in the optimization problem, indicating the resources allocated to each pet.


### Retrieved Values

**Query 1: This data is used as coefficients in the objective function to minimize the total cost of pet care.**

```sql
SELECT pet_type, cost FROM pet_type_costs;
```

**Results (CSV format):**
```csv
pet_type,cost
dog,50.0
cat,30.0
bird,20.0
```

**Query 2: These values define the lower and upper bounds for resource allocation per pet type.**

```sql
SELECT pet_type, min_care, max_care FROM pet_care_requirements;
```

**Results (CSV format):**
```csv
pet_type,min_care,max_care
dog,10.0,100.0
cat,5.0,50.0
bird,3.0,30.0
```

**Query 3: This data is crucial for evaluating the current state of resource allocation and for optimizing it.**

```sql
SELECT pet_id, amount FROM resource_allocation;
```

**Results (CSV format):**
```csv
pet_id,amount
pet1,50.0
pet2,30.0
pet3,20.0
```

**Query 4: This helps in ensuring that the allocated resources are within the required bounds for each pet type.**

```sql
SELECT ra.pet_id, ra.amount, pcr.min_care, pcr.max_care FROM resource_allocation ra JOIN pet_care_requirements pcr ON ra.pet_id = pcr.pet_type;
```

**Results (CSV format):**
```csv
pet_id,amount,min_care,max_care
```

**Query 5: This provides a summary of the current total cost, which is the value to be minimized in the optimization problem.**

```sql
SELECT SUM(ra.amount * ptc.cost) AS total_cost FROM resource_allocation ra JOIN pet_type_costs ptc ON ra.pet_id = ptc.pet_type;
```

**Results (CSV format):**
```csv
total_cost
""
```

**Query 6: This is important for ensuring that the total resources do not exceed the university's maximum resource allocation limit.**

```sql
SELECT SUM(amount) AS total_resources_allocated FROM resource_allocation;
```

**Results (CSV format):**
```csv
total_resources_allocated
100.0
```

**Query 7: This helps in identifying pets that are not receiving adequate care, which is a constraint in the optimization problem.**

```sql
SELECT ra.pet_id, ra.amount, pcr.min_care FROM resource_allocation ra JOIN pet_care_requirements pcr ON ra.pet_id = pcr.pet_type WHERE ra.amount < pcr.min_care;
```

**Results (CSV format):**
```csv
pet_id,amount,min_care
```

**Query 8: This helps in identifying pets that are receiving more resources than necessary, which could be optimized to reduce costs.**

```sql
SELECT ra.pet_id, ra.amount, pcr.max_care FROM resource_allocation ra JOIN pet_care_requirements pcr ON ra.pet_id = pcr.pet_type WHERE ra.amount > pcr.max_care;
```

**Results (CSV format):**
```csv
pet_id,amount,max_care
```

**Query 9: This information can be used to prioritize cost reduction efforts for the most expensive pet types.**

```sql
SELECT pet_type, cost FROM pet_type_costs ORDER BY cost DESC;
```

**Results (CSV format):**
```csv
pet_type,cost
dog,50.0
cat,30.0
bird,20.0
```

**Query 10: This helps in identifying pet types that require the most resources, which could be a focus area for optimization.**

```sql
SELECT pet_type, max_care FROM pet_care_requirements ORDER BY max_care DESC;
```

**Results (CSV format):**
```csv
pet_type,max_care
dog,100.0
cat,50.0
bird,30.0
```

