# Complete Optimization Problem and Solution: race_track

## 1. Problem Context and Goals

### Context  
A race track management company is tasked with optimizing the utilization of seating capacity across all its tracks for the upcoming year. The company operates multiple tracks, each with a specific seating capacity and a maximum allowable number of races. The primary business decision involves determining the number of races to be held at each track to maximize the total seating capacity utilization. This decision must respect two key operational constraints: the maximum number of races allowed at each track and the total available seating capacity across all tracks. The total seating capacity is a fixed value determined by the company’s business configuration, ensuring that the overall seating utilization does not exceed the company’s operational limits. The problem is designed to align with linear optimization principles, focusing on straightforward relationships between seating capacities, race counts, and operational constraints without introducing nonlinear complexities.

### Goals  
The optimization goal is to maximize the total seating capacity utilization across all races held at the company’s tracks. This is achieved by strategically determining the number of races at each track, weighted by their respective seating capacities. Success is measured by the total seating utilization, which is the sum of the seating capacity of each track multiplied by the number of races held there. The objective is to ensure that the company’s resources are used efficiently while adhering to operational constraints.

## 2. Constraints  

The optimization problem is subject to two primary constraints:  
1. **Race Limit per Track**: The number of races held at each track cannot exceed the maximum number of races allowed for that track. This ensures that each track operates within its capacity for hosting events.  
2. **Total Seating Capacity**: The total seating utilization across all tracks must not exceed the company’s total available seating capacity. This ensures that the company’s overall seating resources are not overutilized.  

These constraints are designed to align with linear optimization principles, ensuring that the relationships between variables and constraints remain straightforward and avoid nonlinear complexities.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization requirements and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE track (
  Seating INTEGER
);

CREATE TABLE track_races (
  Races INTEGER
);

CREATE TABLE track_limits (
  Max_Races INTEGER
);
```

### Data Dictionary  
- **track**: Stores information about each race track.  
  - **Seating**: Represents the seating capacity of the track. This value is used as a coefficient in the optimization objective to calculate total seating utilization.  
- **track_races**: Stores the number of races to be held at each track.  
  - **Races**: Represents the decision variable in the optimization model, determining the number of races at each track.  
- **track_limits**: Stores the maximum number of races allowed per track.  
  - **Max_Races**: Represents the upper bound constraint for the number of races at each track.  


### Retrieved Values

**Query 1: Query Description: Retrieve the seating capacity of each track. This is crucial for the objective function as it serves as the coefficient for the number of races to maximize total seating utilization.**

```sql
SELECT Seating FROM track;
```

**Results (CSV format):**
```csv
Seating
5000
10000
15000
```

**Query 2: Query Description: Retrieve the maximum number of races allowed per track. This is essential for the race limit constraint, ensuring that the number of races at each track does not exceed its operational capacity.**

```sql
SELECT Max_Races FROM track_limits;
```

**Results (CSV format):**
```csv
Max_Races
10
12
15
```

**Query 3: Query Description: Retrieve the current number of races planned for each track. This data is important as it represents the decision variable in the optimization model, which needs to be optimized to maximize seating utilization.**

```sql
SELECT Races FROM track_races;
```

**Results (CSV format):**
```csv
Races
3
5
7
```

**Query 4: Query Description: Retrieve the total seating capacity across all tracks. This is necessary for the total seating capacity constraint, ensuring that the overall seating utilization does not exceed the company’s operational limits.**

```sql
SELECT SUM(Seating) AS Total_Seating_Capacity FROM track;
```

**Results (CSV format):**
```csv
Total_Seating_Capacity
30000
```

**Query 5: Query Description: Retrieve the total maximum number of races allowed across all tracks. This provides an upper bound on the total number of races that can be held, which is useful for understanding the overall operational capacity.**

```sql
SELECT SUM(Max_Races) AS Total_Max_Races FROM track_limits;
```

**Results (CSV format):**
```csv
Total_Max_Races
37
```

**Query 6: Query Description: Retrieve the total seating utilization across all tracks based on the current number of races. This provides a baseline for the optimization objective, showing the current total seating utilization.**

```sql
SELECT SUM(t.Seating * tr.Races) AS Total_Seating_Utilization FROM track t JOIN track_races tr ON t.Seating = tr.Races;  -- Assuming there is a logical relationship or key to join these tables;
```

**Results (CSV format):**
```csv
Total_Seating_Utilization
""
```

