# Complete Optimization Problem and Solution: shop_membership

## 1. Problem Context and Goals

### Context  
A retail chain is focused on optimizing the allocation of membership benefits across its branches to maximize customer satisfaction. Customer satisfaction is measured by the total pounds spent by members at each branch. The business must make decisions on how to allocate resources to each branch to achieve this goal while adhering to two key operational limitations:  
1. **Total Membership Benefits Budget**: The retail chain has a fixed total budget allocated for membership benefits across all branches. This budget cannot be exceeded when distributing benefits.  
2. **Branch Capacity Limits**: Each branch has a maximum number of members it can handle, which is determined by its operational capacity. The total pounds spent by members at a branch must not exceed this capacity.  

The business configuration includes:  
- A total budget of 500,000 units allocated for membership benefits across all branches.  
- A formula to calculate the total capacity across all branches, which is the sum of the maximum number of members each branch can handle.  

The decision variables in this problem are the total pounds spent by members at each branch, which are continuous values. The goal is to maximize the sum of these values across all branches while respecting the budget and capacity constraints.  

### Goals  
The primary goal of this optimization problem is to maximize the total pounds spent by members across all branches. This metric directly reflects customer satisfaction and is aligned with the retail chain’s objective of enhancing member engagement. Success is measured by achieving the highest possible sum of total pounds spent while staying within the allocated budget and respecting each branch’s capacity limits.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Total Membership Benefits Budget**: The sum of the membership amounts allocated to all branches must not exceed the total budget of 500,000 units. This ensures that the retail chain operates within its financial limits.  
2. **Branch Capacity Limits**: The sum of the total pounds spent by members at all branches must not exceed the total capacity across all branches. This ensures that no branch is overloaded beyond its operational capabilities.  

These constraints are designed to ensure that the optimization problem remains linear, avoiding any scenarios that would require nonlinear relationships such as variable products or divisions.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating a new table for branch capacity, modifying the purchase table to better map constraints, and adding configuration logic for budget and capacity limits.

CREATE TABLE purchase (
  Total_pounds FLOAT,
  branch_id INTEGER
);

CREATE TABLE branch (
  membership_amount FLOAT
);

CREATE TABLE branch_capacity (
  max_members INTEGER
);
```

### Data Dictionary  
- **purchase Table**:  
  - **Total_pounds**: Represents the total pounds spent by members at a specific branch. This is the key decision variable and objective coefficient in the optimization problem.  
  - **branch_id**: Identifies the branch where the purchase was made. This is used to map constraints to specific branches.  

- **branch Table**:  
  - **membership_amount**: Represents the maximum membership amount allocated to a branch. This is used as a constraint bound to ensure the total budget is not exceeded.  

- **branch_capacity Table**:  
  - **max_members**: Represents the maximum number of members a branch can handle. This is used as a constraint bound to ensure branch capacities are respected.  


### Retrieved Values

**Query 1: Purpose: To understand the current distribution of pounds spent across branches, which will be optimized.**

```sql
SELECT branch_id, SUM(Total_pounds) AS total_pounds_spent FROM purchase GROUP BY branch_id;
```

**Results (CSV format):**
```csv
branch_id,total_pounds_spent
1,150.75
2,200.5
3,300.0
```

**Query 2: Purpose: To gather data on the current allocation of membership benefits, which will be used to enforce the budget constraint.**

```sql
SELECT branch_id, membership_amount FROM branch;
```

**Error:** Execution failed on sql 'SELECT branch_id, membership_amount FROM branch;': no such column: branch_id

**Query 3: Purpose: To gather data on the operational capacity of each branch, which will be used to enforce the capacity constraint.**

```sql
SELECT branch_id, max_members FROM branch_capacity;
```

**Error:** Execution failed on sql 'SELECT branch_id, max_members FROM branch_capacity;': no such column: branch_id

**Query 4: Purpose: To ensure that the sum of membership amounts across all branches does not exceed the total budget of 500,000 units.**

```sql
SELECT SUM(membership_amount) AS total_budget FROM branch;
```

**Results (CSV format):**
```csv
total_budget
22500.0
```

**Query 5: Purpose: To ensure that the sum of total pounds spent by members across all branches does not exceed the total capacity.**

```sql
SELECT SUM(max_members) AS total_capacity FROM branch_capacity;
```

**Results (CSV format):**
```csv
total_capacity
450
```

**Query 6: This data will be used to make informed decisions on how to allocate resources optimally.**

```sql
SELECT p.branch_id, SUM(p.Total_pounds) AS total_pounds_spent, b.membership_amount, bc.max_members FROM purchase p JOIN branch b ON p.branch_id = b.branch_id JOIN branch_capacity bc ON p.branch_id = bc.branch_id GROUP BY p.branch_id, b.membership_amount, bc.max_members;
```

**Error:** Execution failed on sql 'SELECT p.branch_id, SUM(p.Total_pounds) AS total_pounds_spent, b.membership_amount, bc.max_members FROM purchase p JOIN branch b ON p.branch_id = b.branch_id JOIN branch_capacity bc ON p.branch_id = bc.branch_id GROUP BY p.branch_id, b.membership_amount, bc.max_members;': no such column: b.branch_id

**Query 7: Purpose: To understand the overall customer satisfaction metric, which is the sum of total pounds spent by members across all branches.**

```sql
SELECT SUM(Total_pounds) AS total_pounds_spent_all_branches FROM purchase;
```

**Results (CSV format):**
```csv
total_pounds_spent_all_branches
651.25
```

**Query 8: Purpose: To ensure that the total membership benefits budget constraint is respected.**

```sql
SELECT SUM(membership_amount) AS total_membership_amount FROM branch;
```

**Results (CSV format):**
```csv
total_membership_amount
22500.0
```

**Query 9: Purpose: To ensure that the total capacity constraint is respected.**

```sql
SELECT SUM(max_members) AS total_capacity FROM branch_capacity;
```

**Results (CSV format):**
```csv
total_capacity
450
```

